import * as SQLite from 'expo-sqlite';

const dbPromise = SQLite.openDatabaseAsync('settings.db');

export const DatabaseService = {
    async init() {
        const db = await dbPromise;
        await db.execAsync(`
            PRAGMA journal_mode = WAL;
            CREATE TABLE IF NOT EXISTS preferences (key TEXT PRIMARY KEY, value TEXT);
        `);
    },

    async getTheme(): Promise<'light' | 'dark' | null> {
        const db = await dbPromise;
        const result = await db.getFirstAsync<{ value: string }>(
            'SELECT value FROM preferences WHERE key = ?',
            'theme'
        );
        return result ? (result.value as 'light' | 'dark') : null;
    },

    async setTheme(theme: 'light' | 'dark') {
        const db = await dbPromise;
        await db.runAsync(
            'INSERT OR REPLACE INTO preferences (key, value) VALUES (?, ?)',
            'theme',
            theme
        );
    }
};