import React from 'react';
import { createStackNavigator } from '@react-navigation/stack';
import CartScreen from '../pages/CartScreen';
import RecapScreen from '../pages/RecapScreen';
import HistoryScreen from '../pages/HistoryScreen';

const Stack = createStackNavigator();

export default function CartNavigator() {
    return (
        <Stack.Navigator initialRouteName="CartMain">
            <Stack.Screen
                name="CartMain"
                component={CartScreen}
                options={{ headerShown: false }}
            />
            <Stack.Screen
                name="RecapScreen"
                component={RecapScreen}
                options={{
                    title: 'Récapitulatif',
                    headerBackTitle: 'Panier'
                }}
            />
            <Stack.Screen
                name="HistoryScreen"
                component={HistoryScreen}
                options={{
                    title: 'Historique des commandes',
                    headerBackTitle: 'Récapitulatif'
                }}
            />
        </Stack.Navigator>
    );
}