int[] regle;
int[][] table;

void setup(){
  size(1001, 1000);
  regle = new int[8];
  table = new int[80][100];
  table[0][50] = 1;
}

void draw(){
  background(255);
  rect(0, 0, 1000, 125);
  for(int i=7; i>=0; i--)
    regle(i, 125*(7-i), 0);
  affichageTable();
}

void regle(int numRegle, int x, int y){
  String sRegle = Integer.toBinaryString(numRegle);
  sRegle = String.format("%03d", Integer.parseInt(sRegle));
  fill(255);
  stroke(0);
  rect(x, y, 125, 125);
  
  if(sRegle.charAt(0) == '1'){
    fill(0);
  }else{
    fill(255);
  }
  rect(x+5, y+10, 35, 35);
  if(sRegle.charAt(1) == '1'){
    fill(0);
  }else{
    fill(255);
  }
  rect(x+45, y+10, 35, 35);
  if(sRegle.charAt(2) == '1'){
    fill(0);
  }else{
    fill(255);
  }
  rect(x+85, y+10, 35, 35);
  if(regle[numRegle] == 1){
    fill(0);
  }else{
    fill(255);
  }
  rect(x+45, y+80, 35, 35);
}

void mousePressed(){
  if(mouseY < 125){
    int numRegle = 7 - mouseX/125;
    regle[numRegle] = (regle[numRegle] + 1) % 2;
    calculTable();
  }else if(mouseY < 160){
    int numCase = mouseX/10;
    table[0][numCase] = (table[0][numCase] + 1) % 2;
    calculTable();
  }
}

void affichageTable(){
  fill(255);
  stroke(0);
  for(int lig = 0; lig < table.length; lig++){
    for(int col = 0; col < table[0].length; col++){
      if(table[lig][col] == 1){
        fill(0);
      }else{
        fill(255);
      }
      rect(col*10, lig*10 + 150, 10, 10);
    }
  }
}

void calculTable(){
  for(int lig = 1; lig < table.length; lig++){
    for(int col = 0; col < table[0].length; col++){
      int caseGauche = (col > 0)?table[lig-1][col-1]:0;
      int caseDessus = table[lig-1][col];
      int caseDroite = (col < table[0].length-1)?table[lig-1][col+1]:0;
      int numRegle = 4 * caseGauche + 2 * caseDessus + 1 * caseDroite;
      table[lig][col] = regle[numRegle];
    }
  }
}