import org.graphstream.graph.BreadthFirstIterator;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.DefaultGraph;
import org.graphstream.stream.file.FileSource;
import org.graphstream.stream.file.FileSourceEdge;
import scala.Int;

import static org.graphstream.algorithm.Toolkit.*;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class AnalyseRI {

    public static void main(String[] args) throws IOException {
        Graph g = new DefaultGraph("g");
        FileSource fs = new FileSourceEdge();

        fs.addSink(g);

        try {
            fs.readAll("/home/bryan/IdeaProjects/TP2/src/fichier.txt");
        } catch( IOException e) {e.printStackTrace();}
        //System.out.println(g.getNodeCount());
        //System.out.println(g.getEdgeCount());
        //System.out.println(averageDegree(g));
        //System.out.println(averageClusteringCoefficient(g));
        //System.out.println(averageDegree(g)/g.getNodeCount());
        //System.out.println(isConnected(g));
        //System.out.println(averageDegree(g)*2>Math.log(g.getNodeCount()));
        System.out.println(Arrays.toString(degreeDistribution(g)));

        ArrayList<Node> echantillon = new ArrayList<Node>();
        for(int i = 0 ; i < 1000 ; i++) {
            int random = (int) (Math.random() * g.getNodeCount());
            Node noeud = g.getNode(random);
            while( echantillon.contains(noeud) ) noeud = g.getNode((int) (Math.random() * g.getNodeCount()));
            echantillon.add(noeud);
        }
        System.out.println("Noeuds aléatoires trouvées");
        ArrayList<Integer> chemins = new ArrayList<Integer>();
        for ( int i = 0 ; i < echantillon.size() ; i++ ) {
            Node noeud = echantillon.get(i);
            BreadthFirstIterator it = new BreadthFirstIterator(noeud);
            for( int j = i+1 ; j < echantillon.size() ; j++ ) {
                Node noeud2 = echantillon.get(j);
                while( it.hasNext() && ! it.next().equals(noeud2) ) {}
                chemins.add(it.getDepthOf(noeud2));
            }
            System.out.println("Noeud " + i + " calculé");
        }
        System.out.println("Chemins calculées");
        int nb = chemins.size();
        int somme = 0;

        Map<Integer, Float> map = new HashMap<>();

        for( Integer d : chemins ) {
            somme+= d;
            if(map.containsKey(d)) {
                map.put(d, map.get(d) + 1);
            } else {
                map.put(d, 1f);
            }
        }
        for (Integer i : map.keySet()) {
            map.put(i, map.get(i) / nb);
            System.out.print(i);
            System.out.print(" ");
            System.out.println(map.get(i));
        }

        System.out.println("somme = " + somme + " | nb = " + nb);
        System.out.println("Longeur moyenne = " + (1.0 *somme/nb));

    }
}
