import './index.css';
import nameGenerator from './name-generator';
import isDef from './is-def';



// Store/retrieve the name in/from a cookie.
const cookies = document.cookie.split(';');
//console.log(cookies)
let wsname = cookies.find(function(c) {
  if (c.match(/wsname/) !== null) return true;
  return false;
});
if (isDef(wsname)) {
  wsname = wsname.split('=')[1];
} else {
  wsname = nameGenerator();
  document.cookie = "wsname=" + encodeURIComponent(wsname);
}

// Set the name in the header
//document.querySelector('header>p').textContent = decodeURIComponent(wsname);

// Create a WebSocket connection to the server
const ws = new WebSocket("ws://" + window.location.host+ "/socket");

// We get notified once connected to the server
ws.onopen = (event) => {
  document.getElementById('loader').className = "active";
};

// Listen to messages coming from the server. When it happens, create a new <li> and append it to the DOM.
let line;
ws.onmessage = (event) => {
  console.log(event.data);
  let my_pseudo = document.getElementById('pseudo').getAttribute("pseudo");
  let message = event.data.split("-");
  if(message[1] != undefined){
    let instructions = message[1].split(" ");
    if(instructions[0] != my_pseudo){
    console.log("ok : "+message[0].toString());
    console.log("SWITCH : "+message[0].split("] ")[1]);
      switch(message[0].split("] ")[1]){
        case "DRAW":
          const draw_box = document.getElementById('draw_box');
          draw_box.value = message.join(" ").split("] ")[1];
          draw_box.click();
          break;
        case "MOVE":
          const move_box = document.getElementById('mouse_box_get');
          console.log(message);
          move_box.value = message[1];
          move_box.click();
          break;
      }
    }
  }
  //messages.appendChild(line);
};

// Retrieve the input element. Add listeners in order to send the content of the input when the "return" key is pressed.
function sendMessage(event){
  event.preventDefault();
  event.stopPropagation();
  if (message_box.value !== '') {
    // Send data through the WebSocket
    ws.send(message_box.value);
    message_box.value = '';
  }
}
const message_box = document.getElementById('message_box');
message_box.addEventListener('click', sendMessage, true);


// CETTE FONCTION ENVOIE AU SERVEUR QUE LA SOURIS DE L'UTILISATEUR BOUGE
function sendMouse(event){
  event.preventDefault();
  event.stopPropagation();
  let my_pseudo = document.getElementById('pseudo').getAttribute("pseudo");
  if(my_pseudo != null){
    if (mouse_box.value !== '') {
      // Send data through the WebSocket
      ws.send(mouse_box.value);
      mouse_box.value = '';
    }
  }
}
const mouse_box = document.getElementById('mouse_box_send');
mouse_box.addEventListener('click', sendMouse, true);
