$(function(){
  var color = "000000";
  var context = $("#body .right #canvas_size #canvas")[0].getContext("2d");
  context.mozImageSmoothingEnabled = false;
  context.webkitImageSmoothingEnabled = false;
  context.msImageSmoothingEnabled = false;
  context.imageSmoothingEnabled = false;
  var painting = false;
  var image = new Image();
  var pos = [];
  var pseudo = "";
  var friends = [];


  /* ############################################################################################################################################ */
  /* ### EVENTS ################################################################################################################################# */
  /* ############################################################################################################################################ */

  // EVENT : QUAND L'UTILISATEUR CLIQUE GAUCHE SUR UNE COULEUR
  $("#body .left .box .color").on("click", function(){
    change_color($(this), true);
  });
  $("#body .left .box .color").eq(Math.floor(Math.random() * 18)).click();

  // EVENT : QUAND L'UTILISATEUR CLIQUE DROIT SUR UNE COULEUR
  $("#body .left .box .color").on("contextmenu", function(event){
    event.preventDefault();
    change_color($(this), false);
  });
  $("#body .left .box .color").eq(Math.floor(Math.random() * 18)).contextmenu();

  // EVENT : QUAND L'UTILISATEUR CLIQUE SUR LE CANVAS
  $("#body .right #canvas_size #canvas").on("mousedown", function(){
    painting = true;
  });

  // EVENT : QUAND L'UTILISATEUR RELACHE LE CLIQUE DE LA SOURIS SUR LE CANVAS
  $("body").on("mouseup", function(){
    painting = false;
  });

  // EVENT : QUAND L'UTILISATEUR CLIQUE SUR LE CANVAS
  $("#body .right #canvas_size #canvas").on("mousemove", function(event){
    let x = Math.floor(event.pageX - $(this).offset().left);
    let y = Math.floor(event.pageY - $(this).offset().top);
    if(painting == true){
      draw_line(pos, [x, y], $("#body .left .box #pencil_size").val(), color, true);
    }
    pos = [x, y];
  });

  // EVENT : QUAND L'UTILISATEUR REDIMENTIONNE L'ECRAN
  $(window).resize(function(){
    resize();
  });

  // EVENT : QUAND L'UTILISATEUR APPUIE SUR LA TOUCHE ENTREE DANS L'INTERFACE DE CO
  $("#loader .center .after input").keypress(function(e) {
    if(e.which == 13) {
      $(this).parent().find("button").click();
    }
  });

  // EVENT : QUAND L'UTILISATEUR CLIQUE SUR SE CONNECTER
  $("#loader .center .after button").click(function(){
    let min = 2;
    let max = 99999;
    let val = $(this).parent().find("input").val();
    if(val != ""){
      pseudo = val+"_"+Math.floor(Math.random() * (max - min + 1));
      $("#top .right input#pseudo").val(val).attr("pseudo", pseudo);
      $(this).parent().parent().parent().remove();
    }
  });

  $("#body .right #canvas_size #draw_box").click(function(){
    let val = $(this).val().split(" ");
    let canvas = $("#body .right #canvas_size #canvas");
    //console.log(val);
    draw_line([val[2]/100*canvas.width(), val[3]/100*canvas.height()], [val[4]/100*canvas.width(), val[5]/100*canvas.height()], val[7], val[6], false);
    $(this).val("");
  });

  // EVENT : QUAND L'UTILISATEUR CLIQUE SUR LE CANVAS
  $("#body .right #canvas_size #canvas").on("mousemove", function(event){
    let x = Math.floor(event.pageX - $(this).offset().left)*100/$(this).width();
    let y = Math.floor(event.pageY - $(this).offset().top)*100/$(this).height();
    /*
    let x = event.pageX*100/$(this).width();
    let y = event.pageY*100/$(this).height();
    */
    $("#mouse_box_send").val("MOVE-"+pseudo+" "+x+" "+y+" "+color).click();
  });

  $("#body .right #canvas_size #mouse_box_get").click(function(){
    let val = $(this).val().split(" ");
    let exist = false;
    for(let cpt = 0; cpt<friends.length; cpt++){
      if(val[0] == friends[cpt].pseudo){
        exist = true;
        friends[cpt].x = val[1];
        friends[cpt].y = val[2];
        friends[cpt].color = val[3];
        $("#body .right #canvas_size div.friend[data-pseudo='"+friends[cpt].pseudo+"']").css("left", friends[cpt].x+"%").css("top", friends[cpt].y+"%").css("color", "#"+friends[cpt].color).find("div").css("background-color", "#"+friends[cpt].color);
        break;
      }
    }
    if(exist == false){
      let obj = {
        "pseudo": val[0],
        "x": val[1],
        "y": val[2],
        "color": val[3]
      };
      friends.push(obj);
      $("#body .right #canvas_size").append("<div style='color:#"+val[3]+";left:"+val[1]+"%;top:"+val[2]+"%;' class='friend' data-pseudo='"+val[0]+"'><div style='background-color:#"+val[3]+";'>"+val[0].split("_")[0]+"</div></div>");
    }
    $(this).val("");
  });

  /* ############################################################################################################################################ */
  /* ### FUNCTIONS ############################################################################################################################## */
  /* ############################################################################################################################################ */

  // CETTE FONCTION DESSINE UNE LIGNE
  function draw_line(first, last, size, color, send){
    let canvas = $("#body .right #canvas_size #canvas");
    context.strokeStyle = "#"+color;

    context.beginPath();
    context.lineTo(first[0], first[1]);
    context.lineTo(last[0], last[1]);
    context.lineWidth = (size/100*canvas.width())/10;
    context.stroke();

    image.src = $("#body .right #canvas_size #canvas")[0].toDataURL();

    if(send == true){
      $("#message_box").val("DRAW-"+pseudo+" "+first[0]*100/canvas.width()+" "+first[1]*100/canvas.height()+" "+last[0]*100/canvas.width()+" "+last[1]*100/canvas.height()+" "+color+" "+size).click();
    }
  }

  // CETTE FONCTION PERMET A L'UTILISATEUR DE CHANGER D'IMAGE
  function change_color(elem, way){
    color = elem.attr("data-value");
    $("#body .left .box #selected_color div:first-child").removeClass().addClass(elem.attr("data-class"));
  }

  // CETTE FONCTION PERMET DE REDIMENTIONNER LE CANVAS
  function resize(){
    let canvas = $("#body .right #canvas_size #canvas");
    canvas.attr("height", canvas.height()).attr("width", canvas.width());
    context.drawImage(image, 0, 0, canvas.width(), canvas.height());
  }
  resize();
});
