import { render, screen } from "@testing-library/react";
import { describe, it, beforeEach, expect, vi } from "vitest";
import Nuage from "../components/Nuage/Nuage";

// Mock
vi.mock("@/src/components/svg/Nuage_svg", () => ({
  default: () => <svg data-testid="nuage-svg" />
}));

describe("page Nuage", () => {

  beforeEach(() => {
    vi.clearAllMocks();

    global.fetch = vi.fn()
      // 1er fetch → departements
      .mockResolvedValueOnce({
        ok: true,
        json: async () => ({
          member: [
            { nom: "Seine-Maritime" },
            { nom: "Calvados" },
          ],
        }),
      } as any)

      // 2e fetch → données communes
      .mockResolvedValueOnce({
        ok: true,
        json: async () => ({
          member: [
            {
              nomCommune: "Le Havre",
              annee: 2022,
              tauxNet: 15,
              montantReel: 2000000,
            },
            {
              nomCommune: "Rouen",
              annee: 2022,
              tauxNet: 18,
              montantReel: 1500000,
            },
          ],
        }),
      } as any);
  });

  it("affiche le titre", async () => {
    render(<Nuage />);
    expect(await screen.findByText(/Relation taux d'imposition/i))
      .toBeInTheDocument();
  });

  it("fait les appels API au montage", async () => {
    render(<Nuage />);

    await screen.findByText(/Relation taux d'imposition/i);

    expect(fetch).toHaveBeenCalled();
  });

  it("rend le svg", async () => {
    render(<Nuage />);

    expect(await screen.findByTestId("nuage-svg"))
      .toBeInTheDocument();
  });

  it("affiche les 3 selects", async () => {
    render(<Nuage />);

    const selects = await screen.findAllByRole("combobox");

    expect(selects.length).toBe(3);
  });

});
