# Web Fullstack Lab (WIP)

Un projet utilisant API Platform et Next.js afin de visualiser des données des impôts locaux issues du site [du gouvernement](https://www.data.gouv.fr/datasets/impots-locaux-fichier-de-recensement-des-elements-dimposition-a-la-fiscalite-directe-locale-rei-3).
L'api est basée sur le framework Symfony et les graphiques sont rendus avec D3.

## Auteurs

|Prénom   | Nom   | Numéro Etudiant |
|---|---|---|
|Antonin|Huser|20191041|
|Tristan|Cherrier|20241682|

## Stacks

- [API Platform](https://api-platform.com)
- [Symfony](https://symfony.com)
- [Next.js](https://nextjs.org)
- [D3](https://d3js.org)


## How to

### Télécharger le projet

```sh
git clone https://www-apps.univ-lehavre.fr/forge/ct241682/web_fullstack_lab.git
```

### Lancer l'api

Se rendre dans le dossier de l'api.
```sh
cd api-platform-4.1.0
```

Construire les dockers.
```sh
sudo docker compose build --no-cache
```

Lancer les dockers.
```sh
sudo docker compose up --wait
```

### Préparer l'api

Une fois les docker lancés, on peut peupler la base de données avec les données avec les commandes suivantes :

- Téléchargement et préparation des fichiers :
```sh
sudo docker compose exec php bin/console app:prepare-data
```
Cette commande va télécharger les dossiers zip depuis le site data.gouv.fr, récupérer automatiquement les fichiers voulus, les renommer,  et convertir le fichier de données principal en csv (plus pratique à manipuler. separator ";") pour chaque année définie (2018-2022 inclus).

- Peuplement de la table des départements
```sh
sudo docker compose exec php bin/console app:fill-depts
```
La commande suivante échouera sans la liste des départements existante.

- Importation des données depuis les csv :
```sh
sudo docker compose exec php bin/console app:import-xlsx --no-debug
```
L'argument --no-debug est nécessaire ici pour éviter de saturer la mémoire.

L'api est maintenant prête avec les données et disponible à l'adresse :

```
localhost/docs
```

### Tests API

Créer la base de test
```
sudo docker compose exec php bin/console doctrine:database:create --env=test
```

Créer les tables
```
sudo docker compose exec php bin/console doctrine:schema:create --env=test
```

Load les fixtures en base (données de test)
```
sudo docker compose exec php bin/console doctrine:fixtures:load --env=test
```

Lancer les tests
```
sudo docker compose exec php php bin/phpunit
```

### Lancer le site web

Se rendre dans le dossier de l'application, web.
```sh
cd .. && cd /my-app
```

Télécharger les dépendances.
```sh
npm install
```

Pour ce projet, on lance l'environnement de développement, simplement pour tester.
```sh
npm run dev
```

