import { taxeStats } from "@/src/type/TaxeStats";

export const fetchTaxeData = async (taxe: string, year: number, metric: string): Promise<taxeStats[]> => {
    const response = await fetch(
        `https://localhost/${taxe}/stats?annee=${year}&groupBy=region&metric=${metric}`
    );

    if (!response.ok) {
        throw new Error(`Erreur API pour l'année ${year}`);
    }

    const apiData = await response.json();

    // On transforme le résultat pour qu'il corresponde à ton interface taxeStats
    return apiData.member.map((d: any) => ({
        region: d.label,
        year: year,
        value: d.value,
    }));
};