<?php

namespace App\Entity;

use ApiPlatform\Metadata\ApiResource;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity]
#[ApiResource]
class Tfpb
{
    #[ORM\Id]
    #[ORM\Column(type: 'integer')]
    #[ORM\GeneratedValue(strategy: 'SEQUENCE')]
    private ?int $id = null;

    #[ORM\Column]
    private ?int $annee = null;

    #[ORM\Column]
    private ?int $departement = null;

    #[ORM\Column(length: 255)]
    private ?string $nomCommune = null;

    #[ORM\Column]
    private ?float $tauxNet = null;

    #[ORM\Column]
    private ?float $montantReel = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getAnnee(): ?int
    {
        return $this->annee;
    }

    public function setAnnee(int $annee): static
    {
        $this->annee = $annee;

        return $this;
    }

    public function getDepartement(): ?int
    {
        return $this->departement;
    }

    public function setDepartement(int $departement): static
    {
        $this->departement = $departement;

        return $this;
    }

    public function getNomCommune(): ?string
    {
        return $this->nomCommune;
    }

    public function setNomCommune(string $nomCommune): static
    {
        $this->nomCommune = $nomCommune;

        return $this;
    }

    public function getTauxNet(): ?float
    {
        return $this->tauxNet;
    }

    public function setTauxNet(float $tauxNet): static
    {
        $this->tauxNet = $tauxNet;

        return $this;
    }

    public function getMontantReel(): ?float
    {
        return $this->montantReel;
    }

    public function setMontantReel(float $montantReel): static
    {
        $this->montantReel = $montantReel;

        return $this;
    }

}