import { render, screen, waitFor } from "@testing-library/react";
import Temporelle from "../components/Temporelle/Temporelle";
import { describe, test, vi, expect } from "vitest";


// Mock du fetch global
global.fetch = vi.fn(() =>
  Promise.resolve({
    ok: true,
    json: () =>
      Promise.resolve({
        member: [
          { label: "Normandie", value: 10 },
          { label: "Bretagne", value: 12 },
        ],
      }),
  })
) as any;

describe("page Temporelle", () => {

  test("affiche le titre", () => {
    render(<Temporelle />);
    expect(screen.getByText(/Taux d'imposition moyen/i)).toBeInTheDocument();
  });

  test("affiche les selects", () => {
    render(<Temporelle />);
    expect(screen.getByText("Taxe")).toBeInTheDocument();
    expect(screen.getByText("De")).toBeInTheDocument();
    expect(screen.getByText("à")).toBeInTheDocument();
  });

  test("fetch les données et affiche le graphique", async () => {
    render(<Temporelle />);

    await waitFor(() => {
      expect(fetch).toHaveBeenCalled();
    });

    expect(document.querySelector("svg")).toBeInTheDocument();
  });

});
