import { render, screen } from "@testing-library/react";
import { beforeEach, describe, expect, it, vi } from "vitest";
import Diagramme from "../components/Diagramme/Diagramme";

describe("page Diagramme", () => {

    beforeEach(() => {
        vi.clearAllMocks();


        global.fetch = vi.fn().mockResolvedValue({
            ok: true,
            json: async () => ({
                member: [
                    { label: "Normandie", value: 100000 },
                    { label: "Bretagne", value: 200000 },
                ],
            }),
        } as any);
    });

    it("affiche le titre", async () => {
        render(<Diagramme />);
        expect(await screen.findByText(/Impôt collecté/i)).toBeInTheDocument();
    });

    it("fait un appel API au montage", async () => {
        render(<Diagramme />);

        await screen.findByText(/Impôt collecté/i);

        expect(fetch).toHaveBeenCalled();
    });

    it("rend un svg", async () => {
        render(<Diagramme />);

        await screen.findByText(/Impôt collecté/i);

        const svg = document.querySelector("svg");
        expect(svg).toBeInTheDocument();
    });

});
