const express = require('express');
const passport = require('passport');
const router = new express.Router();

const encrypt = require('../src/utils').encrypt;

const users = require('../models/user');

router
    .get('/register', function(req, res, next) {
      res.render('register', {
        title: 'Inscription',
        roles: Object.values(users.USER_ROLE),
      });
    })
    .post('/register', function(req, res, next) {
      users.User.findOne({email: req.body.email})
          .then((u) => {
            if (u) {
              req.flash('info', 'Cette adresse email est déjà prise');
              res.redirect('/register');
            } else {
              const newUser = new users.User({
                name: req.body.name,
                role: req.body.role,
                email: req.body.email,
                password: encrypt(req.body.password),
              });
              return newUser.save();
            }
          })
          .then(
              (u) => {
                if (u) res.redirect('/login');
              },
              (err) => {
                Object.values(err.errors).forEach((err) => {
                  return req.flash('info', err.message);
                });
                res.redirect('/register');
              },
          )
          .catch(next);
    })
    .get('/login', function(req, res, next) {
      res.render('login', {title: 'Connexion'});
    })
    .post('/login', function(req, res, next) {
      passport.authenticate('local', function(err, user, info) {
        if (err) {
          return next(err);
        }

        if (!user) {
          req.flash('error', 'Ce compte n\'est pas enregistré');
          return res.redirect('/login');
        }

        req.logIn(user, function(err) {
          if (err) {
            return next(err);
          }

          return res.redirect('/ads/');
        });
      })(req, res, next);
    })
    .get('/logout', function(req, res) {
      req.logout();
      res.redirect('/');
    });

module.exports = router;
