/**
 * Send HTTP request to delete ad, and follow redirection afterwise.
 *
 * @param {Event} e
 */
function deleteAd(e) {
  const id = e.target.dataset.id;

  fetch(`/ads/delete/${id}`, {
    method: 'DELETE',
    mode: 'cors',
    cache: 'no-cache',
    credentials: 'same-origin',
    headers: {
      'Content-Type': 'application/json',
    },
    redirect: 'follow',
    referrer: '',
  })
      .then((value) => (window.location = value.url))
      .catch((reason) => console.error(reason));
}

document.addEventListener('DOMContentLoaded', function() {
  document.querySelectorAll('.delete-button').forEach((btn) => {
    btn.addEventListener('click', deleteAd);
  });
});
