const adModel = require('../models/ad');

const chai = require('chai');
const chaiHttp = require('chai-http');

// mocha needs it
const should = chai.should();

process.env.NODE_ENV = 'test';
require('dotenv').config();
const server = require('../app');

chai.use(chaiHttp);

describe('Les annonces', () => {
  before((done) => {
    adModel.Ad.deleteMany({}, (err) => {
      if (err) {
        console.error(err);
      }

      done();
    });
  });

  // Requête de consultation des annonces
  describe('Action de listing des annonces', () => {
    it('Supposément obtient les annonces décrites ci-dessous', (done) => {
      chai.request(server)
          .get('/ads/')
          .end((err, res) => {
            res.should.be.html;
            res.should.have.status(200);
            done();
          });
    });
  });

  // Requêtes de création d'annonce
  describe('Actions de création des annonces', () => {
    it('Supposément obtient la page de création d\'annonce', (done) => {
      chai.request(server)
          .get('/ads/create')
          .end((err, res) => {
            res.should.be.html;
            res.should.have.status(200);
            done();
          });
    });

    it('Supposément crée une annonce correcte', (done) => {
      const formData = {
        '_method': 'put',
        'title': 'Test',
        'type': adModel.AD_TYPE.VALUE.RENTAL,
        'transactionStatus': adModel.AD_TRANSACTIONSTATUS.VALUE.AVAILABLE,
        'price': '420,69',
        'published': undefined,
      };

      chai.request(server)
          .post('/ads/create')
          .type('form')
          .send(formData)
          .end((err, res) => {
            res.should.have.status(200);
            done();
          });
    });

    it('Supposément rejette l\'annonce ' +
      'car il lui manque des champs requis', (done) => {
      const formData = {
        '_method': 'put',
        'title': 'Manque des champs obligatoires',
      };

      chai.request(server)
          .post('/ads/create')
          .type('form')
          .send(formData)
          .end((err, res) => {
            res.should.be.html;
            res.should.have.status(406);
            done();
          });
    });

    it('Supposément rejette l\'annonce ' +
      'car le champ price pas conforme', (done) => {
      const formData = {
        '_method': 'put',
        'title': 'Champ price pas conforme',
        'type': adModel.AD_TYPE.VALUE.RENTAL,
        'transactionStatus': adModel.AD_TRANSACTIONSTATUS.VALUE.AVAILABLE,
        'price': '99999,969',
        'published': 'on',
      };

      chai.request(server)
          .post('/ads/create')
          .type('form')
          .send(formData)
          .end((err, res) => {
            res.should.be.html;
            res.should.have.status(406);
            done();
          });
    });

    it('Supposément rejette l\'annonce ' +
      'car le champ price pas conforme', (done) => {
      const formData = {
        '_method': 'put',
        'title': 'Champ price pas conforme',
        'type': adModel.AD_TYPE.VALUE.RENTAL,
        'transactionStatus': adModel.AD_TRANSACTIONSTATUS.VALUE.AVAILABLE,
        'price': '99999,969',
        'published': 'on',
      };

      chai.request(server)
          .post('/ads/create')
          .type('form')
          .send(formData)
          .end((err, res) => {
            res.should.be.html;
            res.should.have.status(406);
            done();
          });
    });
  });

  // Requêtes de mise à jour d'annonce
  describe('Action de mise à jour d\'annonce', (done) => {
    it('Supposément me donne la page vu que l\'id existe', (done) => {
      adModel.Ad.findOne({}).exec()
          .then((value) => {
            chai.request(server)
                .get(`/ads/update/${value.id}`)
                .end((err, res) => {
                  res.should.be.html;
                  res.should.have.status(200);
                });
          })
          .catch((reason) => {
            console.log(reason);
            chai.assert(true);
          })
          .finally(() => done());
    });

    it('Supposément plante vu que l\'id existe pas en fait', (done) => {
      chai.request(server)
          .get(`/ads/update/5`)
          .end((err, res) => {
            res.should.be.html;
            res.should.have.status(404);
            done();
          });
    });
  });

  // Requêtes de suppression d'annonce
  describe('Action de suppression d\'annonce', (done) => {
    it('Supposément plante vu que l\'id existe pas en fait', (done) => {
      chai.request(server)
          .delete(`/ads/delete/aaaaaaaaaaaaaaaaaaaaaaaa`)
          .end((err, res) => {
            res.should.have.status(404);
            done();
          });
    });

    it('Supposément supprime bien vu que l\'id existe', (done) => {
      adModel.Ad.findOne({}).exec()
          .then((value) => {
            chai.request(server)
                .delete(`/ads/delete/${value.id}`)
                .end((err, res) => {
                  res.should.be.html;
                  res.should.have.status(200);
                });
          })
          .catch((reason) => {
            console.log(reason);
            chai.assert(true);
          })
          .finally(() => done());
    });

    it('Supposément part en couille ' +
    'vu que l\'id est pas sous le bon format', (done) => {
      chai.request(server)
          .delete(`/ads/delete/5`)
          .end((err, res) => {
            res.should.have.status(500);
            done();
          });
    });
  });
});
