/**
 * Adds event listener to file input so that
 * it shows selected images in real time
 */
function picturesWatch() {
  const picturesInput = document.querySelector('#pictures');
  const picturesOutput = document.querySelector('#pictures-display');

  picturesInput.addEventListener('change', (e) => {
    const files = e.target.files;

    // Clear existing images
    while (picturesOutput.lastChild) {
      picturesOutput.removeChild(picturesOutput.lastChild);
    }

    for (const file of files) {
      if (!file.type.startsWith('image/')) {
        continue;
      }

      const img = document.createElement('img');
      img.file = file;

      picturesOutput.appendChild(img);

      // Read file's contents and assign it to img
      const reader = new FileReader();
      reader.onload = (function(aImg) {
        return function(e) {
          aImg.src = e.target.result;
        };
      })(img);
      reader.readAsDataURL(file);
    }
  });
}

document.addEventListener('DOMContentLoaded', function() {
  picturesWatch();
  console.info('file input is being watched');
});
