const mongoose = require('mongoose');
const Schema = mongoose.Schema;

const AD_TYPE = {
  VALUE: {
    SALE: 'sale',
    RENTAL: 'rental',
  },
  LANG: {
    SALE: 'A la vente',
    RENTAL: 'A la location',
  },
};

const AD_TRANSACTION_STATUS = {
  VALUE: {
    AVAILABLE: 'available',
    RENTED: 'rented',
    SOLD: 'sold',
  },
  LANG: {
    AVAILABLE: 'Disponible',
    RENTED: 'Louée',
    SOLD: 'Vendue',
  },
};

const postTemplate = {
  author: {
    type: String,
    trim: true,
  },
  body: {
    type: String,
    trim: true,
    required: [true, 'Le corps du message ne peut être vide !'],
  },
  date: {
    type: Date,
    get: (d) => d && d.toLocaleDateString(),
  },
};

const adSchema = new Schema({
  title: {
    type: String,
    required: [true, 'Titre requis'],
    trim: true,
  },
  type: {
    type: String,
    required: [true, 'Type de bien requis'],
    enum: Object.values(AD_TYPE.VALUE),
  },
  published: {
    type: Boolean,
    required: [true, 'État de publication requis'],
  },
  transactionStatus: {
    type: String,
    required: [true, 'Statut de transaction requis'],
    enum: Object.values(AD_TRANSACTION_STATUS.VALUE),
  },
  price: {
    type: Number,
    required: [true, 'Prix requis'],
    validate: {
      validator: (_) => {
        return String(_).match(/^\d+(\.\d{2})?$/);
      },
      msg: 'Le prix doit avoir au maximum 2 chiffres de centimes',
    },
  },
  description: {
    type: String,
    trim: true,
  },
  availabilityDate: {
    type: Date,
  },
  pictures: [{body: Buffer, title: String}],
  questions: [{
    ...postTemplate,
    answers: [{
      ...postTemplate,
    }],
  }],
});

module.exports = {
  AD_TYPE: AD_TYPE,
  AD_TRANSACTIONSTATUS: AD_TRANSACTION_STATUS,
  Ad: mongoose.model('Ad', adSchema),
};
