const createError = require('http-errors');
const express = require('express');
const path = require('path');
const cookieParser = require('cookie-parser');
const expressSession = require('express-session');
const logger = require('morgan');
const passport = require('passport');
const flash = require('connect-flash');
const LocalStrategy = require('passport-local').Strategy;

const authRouter = require('./routes/auth');
const usersRouter = require('./routes/users');
const adsRouter = require('./routes/ads');

const app = express();

const mongoose = require('mongoose');

require('./src/helpers').addHelpers();
require('dotenv').config();

mongoose.connect(process.env.DB_CONNECTION_STRING, {
  useNewUrlParser: true,
  useUnifiedTopology: true,
});

const User = require('./models/user').User;

passport.use(
    new LocalStrategy(function(email, password, done) {
      const encryptedPassword = require('./src/utils').encrypt(password);

      User.findOne({email: email}, function(err, user) {
        if (err) {
          return done(err);
        }
        if (!user) {
          return done(null, false);
        }
        if (user.password !== encryptedPassword) {
          return done(null, false);
        }
        return done(null, user);
      });
    }),
);

passport.serializeUser(function(user, cb) {
  cb(null, user.id);
});

passport.deserializeUser(function(id, cb) {
  User.findById(id, function(err, user) {
    if (err) {
      return cb(err);
    }
    cb(null, user);
  });
});

// view engine setup
app.set('views', path.join(__dirname, 'views'));
app.set('view engine', 'hbs');

app.use(logger('dev'));
app.use(express.json());
app.use(express.urlencoded({extended: false}));
app.use(cookieParser('l\'immobilier mdr'));
app.use(
    expressSession({
      secret: 'l\'immobilier mdr',
      resave: false,
      saveUninitialized: false,
    }),
);
app.use(express.static(path.join(__dirname, 'public')));
app.use(flash());
app.use(passport.initialize());
app.use(passport.session());

// Define redirect before anything else or the redirect will
// consume the flashes before they get to the user
app.get('/', (req, res) => res.redirect('/ads'));

// Pass data for all renders
// logged user and flash messages
app.use(function(req, res, next) {
  res.locals._user = req.user;
  res.locals._messages = Object.entries(req.flash()).reduce(
      (arr, [type, msgs]) =>
        arr.concat(msgs.map((msg) => ({type, message: msg}))),
      [],
  );
  next();
});

app.use('/', authRouter);
app.use('/users', usersRouter);
app.use('/ads', adsRouter);

// catch 404 and forward to error handler
app.use(function(req, res, next) {
  next(createError(404));
});

// error handler
app.use(function(err, req, res, next) {
  // set locals, only providing error in development
  res.locals.message = err.message;
  res.locals.error = req.app.get('env') === 'development' ? err : {};

  // render the error page
  res.status(err.status || 500);
  res.render('error');
});

module.exports = app;
