const userModel = require('../models/user');

const chai = require('chai');
const chaiHttp = require('chai-http');

// mocha needs it
const should = chai.should();

process.env.NODE_ENV = 'test';
require('dotenv').config();
const server = require('../app');

chai.use(chaiHttp);

describe('Role managment', () => {
  const userData = {
    name: 'test',
    email: 'test.test@test.com',
    role: userModel.USER_ROLE.AGENT,
    password: 'testtest',
  };

  /**
   * Registering an user before each test on this section
   * The registered user will be used because this section
   * works with authentication.
   */

  beforeEach(async () => {
    await userModel.User.deleteMany({}).exec();

    await chai.request(server)
        .get('/logout');

    await chai.request(server)
        .post('/register')
        .send(userData);
  });

  describe('Role managment page', () => {
    it('should return 200 if the user is a superadmin', async () => {
      const res = await chai.request(server)
          .post('/login')
          .send({username: userData.email, password: userData.password}).;

      console.log(res.);
    });
  });
});

/*
describe('Les utilisateurs', () => {
  before((done) => {
    userModel.User.deleteMany({}, (err) => {
      if (err) {
        console.error(err);
      }

      done();
    });
  });

  const clientData = {
    name: 'Client',
    role: 'client',
    email: 'client.test@test.test',
    password: '123mdr',
  };

  const agentData = {
    name: 'Agent',
    role: 'agent',
    email: 'agent.test@test.test',
    password: '123mdr',
  };

  // Requête de consultation des annonces
  describe('Action de création d\'utilisateur', () => {
    it('Supposément récupère la page de register', (done) => {
      chai.request(server)
          .get('/register')
          .end((err, res) => {
            res.should.be.html;
            res.should.have.status(200);
            done();
          });
    });

    it('Supposément crée un user client', (done) => {
      chai.request(server)
          .post('/register')
          .type('form')
          .send(clientData)
          .end((err, res) => {
            res.should.have.status(200);
            done();
          });
    });

    it('Supposément crée un user agent', (done) => {
      chai.request(server)
          .post('/register')
          .type('form')
          .send(agentData)
          .end((err, res) => {
            res.should.have.status(200);
            done();
          });
    });

    it('Supposément refuse de créer car email existe déjà', (done) => {
      chai.request(server)
          .post('/register')
          .type('form')
          .send(agentData)
          .end((err, res) => {
            res.should.have.status(409);
            done();
          });
    });

    it('Supposément refuse de créer car email incorrect', (done) => {
      agentData.email = 'null';

      chai.request(server)
          .post('/register')
          .type('form')
          .send(agentData)
          .end((err, res) => {
            res.should.have.status(400);
            done();
          });
    });
  });

  describe('Actions d\'authentification', () => {
    it('Supposément récupère la page de register', (done) => {
      chai.request(server)
          .get('/login')
          .end((err, res) => {
            res.should.be.html;
            res.should.have.status(200);
            done();
          });
    });

    it('Supposément se connecte avec un user client', (done) => {
      chai.request(server)
          .post('/login')
          .type('form')
          .send({
            email: clientData.email,
            password: clientData.password,
          })
          .end((err, res) => {
            res.should.have.status(200);
            done();
          });
    });

    it('Supposément se connecte avec un user agent', (done) => {
      chai.request(server)
          .post('/login')
          .type('form')
          .send({
            email: agentData.email,
            password: agentData.password,
          })
          .end((err, res) => {
            res.should.have.status(200);
            done();
          });
    });
  });
});*/
