const express = require('express');
const multer = require('multer');
const router = new express.Router();
const checkPermissions = require('../src/permissions').checkPermissions;

const adModel = require('../models/ad');

const upload = multer({
  storage: multer.memoryStorage(),
});

/* GET to get to get to the ad creation form */
router.get('/create', checkPermissions('agent'), function(req, res, next) {
  res.render('ad_create');
})
    .post('/create', checkPermissions('agent'),
        upload.array('pictures', 3), function(req, res, next) {
          const body = req.body;
          const id = body.id;

          const formData = {
            title: body.title,
            type: body.type,
            transactionStatus: body.transactionStatus,
            price: body.price && body.price.replace(',', '.'),
            published: body.published === 'on',
            description: body.description,
            availabilityDate: body.availabilityDate === '' ?
          null : body.availabilityDate,
          };

          errCallback = (reason) => res.status(406).render('ad_create', reason);

          if (id) {
            // Peut-être charger l'objet en amont et le retourner si erreur ?

            adModel.Ad.updateOne({_id: id}, {$set: formData}).exec()
                .then((value) => res.redirect('/ads/'))
                .catch((reason) => {
                  errCallback(reason);
                });
          } else {
            const newAd = new adModel.Ad(formData);

            newAd.save()
                .then((value) => res.redirect('/ads/'))
                .catch((reason) => {
                  errCallback(reason);
                });
          }
        })
    .get('/', function(req, res, next) {
      adModel.Ad.find({published: true}).exec()
          .then((value) => {
            // on trie les annonces par ordre alphabétique
            res.render('ad_view', {
              ads: value.sort((a, b) => a.title.localeCompare(b.title)),
            });
          })
          .catch((_) => {
            console.log(_);
            res.render('ad_view', {
              ads: [],
              errors: {
                load: 'Un problème est survenu lors du chargement des données',
              },
            });
          });
    })
    .get('/update/:id', checkPermissions('agent'), function(req, res, next) {
      const id = req.params.id;
      let status;

      adModel.Ad.findOne({_id: id}, function(err, ad) {
        const errors = [];
        if (err) {
          errors.push(err.message);
        }
        if (!ad) {
          status = 404;
          errors.push('L\'annonce cherchée n\'a pas été trouvée');
        } else {
          status = 200;
        }

        res.status(status).render('ad_create', {ad: ad, errors_update: errors});
      });
    })
    .delete('/delete/:id', checkPermissions('agent'), function(req, res, next) {
      const id = req.params.id;
      let status;

      adModel.Ad.deleteOne({_id: id}).exec()
          .then((value) => {
            status = value.n === 0 ? 404 : 303;
            req.flash('success', 'L\'annonce a bien été supprimée');
          })
          .catch((reason) => {
            // console.log(reason);
            status = 500;
            req.flash('error', 'L\'annonce n\'a pas pu être supprimée');
          })
          .finally(() => res.redirect(status, '/ads/'));
    })
    .get('/:id/picture/:index', function(req, res, next) {
      adModel.Ad.findOne({_id: req.params.id})
          .then((ad) => {
            res.type('image/*');
            res.send(ad.pictures[parseInt(req.params.index)].body);
          })
          .catch(next);
    });

module.exports = router;
