const hbs = require('hbs');

const addHelpers = function() {
  hbs.registerHelper('ifEquals', function(arg1, arg2, options) {
    return (arg1 === arg2) ? options.fn(this) : options.inverse(this);
  });

  hbs.registerHelper('authorize', function(role, options) {
    const check = require('./permissions').authorizeUser;
    const user = options.data.root._user;

    if (check(user, role)) {
      return options.fn(this);
    }
  });

  hbs.registerHelper('getEnumValue', function(enumName, key, options) {
    const adModule = require('../models/ad');

    switch (enumName) {
      case 'type':
        return adModule.AD_TYPE.LANG[key.toUpperCase()];
      case 'transactionStatus':
        return adModule.AD_TRANSACTIONSTATUS.LANG[key.toUpperCase()];
      default:
        return 'Ressource inconnue';
    };
  });

  hbs.registerHelper('dateToLocaleString', function(date, options) {
    return date && date.toLocaleDateString();
  });

  hbs.registerHelper('dateToISO', function(date, options) {
    return date && date.toISOString().split('T')[0];
  });

  hbs.registerHelper('formatPrice', function(price, options) {
    return price && price.toFixed(2).replace('.', ',');
  });
};

module.exports = {
  addHelpers: addHelpers,
};
