/**
 * Registers listeners to messages so that they can be closed.
 */
function setMessagesListeners() {
  const messages = document.querySelector('.msgs');
  if (messages) {
    const messagesButtons = messages.querySelectorAll('.msg>.close-btn');

    messagesButtons.forEach((btn) => {
      btn.addEventListener('click', (e) => {
        messages.removeChild(e.target.parentNode);
      });
    });
  }
}

/**
 * Registers listeners to answer buttons so that it displays reply form.
 */
function setReplyListeners() {
  const replyButtons = document.querySelectorAll('.reply-btn');

  replyButtons.forEach((btn) => {
    const hiddenForm = btn.parentNode && btn.parentNode.querySelector('.reply-form');
    if (hiddenForm) {
      btn.addEventListener('click', (e) => {
        if (btn.dataset.shown === 't') {
          btn.dataset.shown = 'f';
          btn.innerText = 'Répondre';
          hiddenForm.style.display = 'none';
        } else {
          btn.dataset.shown = 't';
          btn.innerText = 'Cacher';
          hiddenForm.style.display = 'block';
        }
      });
    }
  });
}

document.addEventListener('DOMContentLoaded', function() {
  setMessagesListeners();
  setReplyListeners();
});
