const mongoose = require('mongoose');
const Schema = mongoose.Schema;

const USER_ROLE = {
  CLIENT: 'client',
  AGENT: 'agent',
};

const USER_PERMISSIONS = {
  NOBODY: 0,
  [USER_ROLE.CLIENT]: 1,
  [USER_ROLE.AGENT]: 2,
};

const userSchema = new Schema({
  name: {
    type: String,
    required: [true, 'Nom requis'],
    trim: true,
  },
  email: {
    type: String,
    match: [
      /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/,
      'Format d\'adresse email invalide',
    ],
    required: [true, 'Adresse email requise'],
    trim: true,
  },
  password: {
    type: String,
    minlength: [8, 'Le mot de passe doit faire 8 caractères minimum'],
    required: [true, 'Mot de passe requis'],
    trim: true,
  },
  role: {
    type: String,
    enum: Object.values(USER_ROLE),
    default: USER_ROLE.CLIENT,
  },
});

const User = mongoose.model('User', userSchema);

module.exports = {
  USER_ROLE,
  USER_PERMISSIONS,
  User: User,
};
