import { useEffect, useState } from "react";
import style from "./Chats.module.css";

type ChatsProps = {
    statusCatsInside: number,
    sendMessage: (message: string) => void,
    setIgnoreNextToast: (ignore: boolean) => void
}

export default function Chats({catsInside, sendMessage, setIgnoreNextToast} : ChatsProps) {

    const [catsChar, setCatsChar] = useState('`');

    useEffect(() => {
        const interval = setInterval(() => {
            setCatsChar(catsChar === '`' ? '^' : '`');
        }, 500);
        return () => clearInterval(interval);
    }, [catsChar]);

    return (
        <div>
            <h2>Chats dans la maison</h2>
            <div className={style.catsContainer}>
                <button className={style.arrow} onClick={() => {
                    sendMessage('catEntered')
                    setIgnoreNextToast(true)
                }}>↑</button>
                <p className={style.cats}>{catsInside === 0 ? "0" : `${catsChar} `.repeat(catsInside)}</p>
                <button className={style.arrow} onClick={() => {
                    if(catsInside > 0) {
                        sendMessage('catLeft')
                        setIgnoreNextToast(true)
                    }
                }}>↓</button>
            </div>
        </div>
    )
}