import {useEffect, useState} from "react";
import CatHistoryLine from "./CatHistoryLine";
import LockHistoryLine from "./LockHistoryLine";
import { History } from "../assets/Types";
import style from './CatHistory.module.css'

export default function CatHistory({history} : History) {
    return(
        <div className={style.history}>
            <table className={style.catLog}>
                <tbody>
                    {history.catLog && history.catLog.map((log, index) => (
                        <tr key={index}>
                            <td>{(new Date(log.date)).toLocaleDateString()} - {(new Date(log.date)).toLocaleTimeString()}</td>
                            <td>{log.event === 'left' ? 'A pina has left the house' : 'A pina entered the house'}</td>
                        </tr>
                    ))}
                </tbody>
            </table>
            <table className={style.lockLog}>
                <tbody>
                    {history.lockLog && history.lockLog.map((log, index) => (
                        <tr key={index}>
                            <td>{(new Date(log.date)).toLocaleDateString()} - {(new Date(log.date)).toLocaleTimeString()}</td>
                            <td>{log.event === 'locked' ? 'Locked cat door' : 'Unlocked cat door'}</td>
                        </tr>
                    ))}
                </tbody>
            </table>
        </div>
    )
}
