import { Chart, CategoryScale, LinearScale, BarElement, Title, Tooltip, Legend } from "chart.js";
import React from "react";
import { Line, Bar } from "react-chartjs-2";
import { CatHistoryRecord } from "../assets/Types";

const days  = ['Dimanche', 'Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi'];

export default function CatGraph({records} : {records: CatHistoryRecord[]}){
    Chart.register(CategoryScale, LinearScale, BarElement, Title, Tooltip, Legend);

    const today = new Date();

    const labels = [];
    for(let i = 6; i >= 0; --i) {
        labels.push(days[((today.getDay() - i) + days.length) % days.length]);
    }

    console.log(labels);
    const chartData = {
        labels: labels,
        datasets: [
            {
                label: 'Pinas entrées',
                data: records.reduce((acc, record) => {
                    if(record.event !== 'entered') return acc;
                    const recordDay = (new Date(record.date)).getDay();
                    const todayDay = today.getDay();
                    const dayDiff = (todayDay - recordDay + days.length) % days.length;
                    if(dayDiff > 6) return acc;
                    acc[dayDiff] += 1;
                    return acc;
                }, Array(7).fill(0)).reverse(),
                fill: false,
                backgroundColor: '#36A2EB',
                tension: 1
            },
            {
                label: 'Pinas sorties',
                data: records.reduce((acc, record) => {
                    if(record.event !== 'left') return acc;
                    const recordDay = (new Date(record.date)).getDay();
                    const todayDay = today.getDay();
                    const dayDiff = (todayDay - recordDay + days.length) % days.length;
                    if(dayDiff > 6) return acc;
                    acc[dayDiff] += 1;
                    return acc;
                }, Array(7).fill(0)).reverse(),
                fill: false,
                backgroundColor: '#FF6384',
                tension: 1
            }
        ]
    }

    const options = {
        responsive: true,
        plugins: {
            legend: {
                position: 'top',
            },
            title: {
                display: true,
                text: 'Activité des pina'
            }
        }
    }

    return(
        <React.Fragment>
            <Bar 
                data={chartData}
                options={options}
            />

        </React.Fragment>
    )
}