import style from "./Bouton.module.css";
import {useEffect, useState} from "react";
import {toast} from "react-toastify";

type BoutonProps = {
    statusLocked: boolean,
    sendMessage: (message: string) => void,
    setIgnoreNextToast: (ignore: boolean) => void
}

function Bouton({locked, sendMessage, setIgnoreNextToast} : BoutonProps) {

    function changeStatus() {
        const message = locked ? 'unlock' : 'lock'
        setIgnoreNextToast(true)
        sendMessage(message)
    }

    return(
        <div className={style.btnContainer}>
            <button className={style.btn} onClick={changeStatus}>
                Chatière {locked ? "fermée 🔴" : "ouverte 🟢"}
            </button>
        </div>
    )
}

export default Bouton
