import { WebSocketServer } from 'ws';
import * as dotenv from 'dotenv'
dotenv.config();
 
// Creating a new websocket server
const wss = new WebSocketServer({ port: process.env.WS_PORT})
 
// Creating connection using websocket
wss.on("connection", ws => {
    ws.id = crypto.randomUUID()
    console.log(`New client connected (${ws.id})`)
    // handling what to do when clients disconnects from server
    ws.on("close", () => {
        console.log(`${ws.id} disconnected`)
    });
    // handling client connection error
    ws.onerror = function () {
        console.log("Some WS Error occurred")
    }
});
console.log(`The WebSocket server is running on port ${process.env.WS_PORT}`);

export default wss