import { SerialPort } from 'serialport'
import { ReadlineParser } from '@serialport/parser-readline'
import * as dotenv from 'dotenv'
dotenv.config()
const port = new SerialPort({
    path: process.env.SERIAL_PORT,
    baudRate: parseInt(process.env.SERIAL_BAUDRATE),
    dataBits: 8,
    stopBits: 1,
    parity: 'none',
});
const parser = port.pipe(new ReadlineParser({ delimiter: '\n' }))

port.on('open', () => {
    console.log('serial port open')
})

export {port}
export {parser}