#include <Arduino.h>
#define tiltEnterPin 2
#define tiltLeavePin 3
#define greenPin 4
#define redPin 5
#define switchLockPin 7

#define initCatsInside 1

bool tiltOneHigh, tiltTwoHigh;
bool locked;

int catsInside;
long lastEnteredAt, lastLeftAt, lastSwitchedAt;

void setup() {
  Serial.begin(9600);
  pinMode(switchLockPin, INPUT );
  pinMode(tiltEnterPin, INPUT);
  pinMode(tiltLeavePin, INPUT);
  pinMode(greenPin, OUTPUT);
  pinMode(redPin, OUTPUT);
  digitalWrite(greenPin, HIGH);
  digitalWrite(redPin, LOW);
  attachInterrupt(digitalPinToInterrupt( tiltEnterPin ), catEntered, HIGH );
  attachInterrupt(digitalPinToInterrupt( tiltLeavePin ), catLeft, HIGH );
  catsInside = initCatsInside;
}
volatile bool clicked = false;
void loop() {
  if(digitalRead(switchLockPin) == HIGH) lockUnlock();
}

void printStatus() {
  String status = "{\"locked\": " + (locked ? String("true") : String("false")) + ", \"catsInside\": " + String(catsInside) + "}";
  Serial.println(status);
}

void catEntered() {
  long now = millis();
  if(now - lastEnteredAt < 1000) return;
  ++catsInside;
  lastEnteredAt = now;
  printStatus();
  while(digitalRead(tiltEnterPin) == HIGH) {
    lastEnteredAt = millis();
  }
}

void catLeft() {
  long now = millis();
  if(now - lastLeftAt < 1000) return;
  if(catsInside > 0) --catsInside;
  lastLeftAt = now;
  printStatus();
  while(digitalRead(tiltLeavePin) == HIGH) {
    lastLeftAt = millis();
  }
}

void lockUnlock() {
  long now = millis();
  if(now - lastSwitchedAt < 50) return;
  locked = !locked;
  digitalWrite(greenPin, !locked);
  digitalWrite(redPin, locked);
  printStatus();
  while(digitalRead(switchLockPin) == HIGH) {
    lastSwitchedAt = millis();
  }
}

/*
  SerialEvent occurs whenever a new data comes in the hardware serial RX. This
  routine is run between each time loop() runs, so using delay inside loop can
  delay response. Multiple bytes of data may be available.
*/
String message = "";
void serialEvent() {
  while (Serial.available()) {
    char inChar = (char)Serial.read();
    message += inChar;
    if(inChar == '\n') {
      handleMessage(message);
      message = "";
    }
  }
}

void handleMessage(String message) {
  message.trim();
  if(message == "lock") {
    locked = true;
    digitalWrite(greenPin, LOW);
    digitalWrite(redPin, HIGH);
    printStatus();
  }else if(message == "unlock") {
    locked = false;
    digitalWrite(redPin, LOW);
    digitalWrite(greenPin, HIGH);
    printStatus();
  }else if(message == "catEntered") {
    ++catsInside;
    printStatus();
  }else if(message == "catLeft") {
    if(catsInside > 0) --catsInside;
    printStatus();
  }else if(message == "status") {
    printStatus();
  }else {
    Serial.println("Unknown event");
  }
}