package edu.mermet.tp8.preferences;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

public class Preference
{
	private static Preference instance = null;
	private Properties prop;
	private String nomUtilisateur;
	
	public Preference(String nomUtilisateur)
	{
		this.nomUtilisateur = nomUtilisateur;
		creerPreferences();		
		Preference.instance = this;
	}

	private void creerPreferences()
	{
		File f = new File("ihm");
		Path path = Paths.get(f.getName());

		if(!f.isDirectory())
		{
			try {
				Files.createDirectory(path);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		String chemin = "./ihm/" + nomUtilisateur+".xml";
		f = new File(chemin);
		prop = new Properties();

		if(!f.isFile())	
		{
			OutputStream os = null;
			prop.setProperty("Conversion Celsius/Farenheit", "Auto");
			prop.setProperty("Saisie de texte", "Auto");
			prop.setProperty("Diaporama", "Auto");
			prop.setProperty("Boutons", "Auto");
			
			
			try {
				os = new FileOutputStream(chemin);
				prop.storeToXML(os,"Préférence de l'utilisateur");
				} catch (IOException e) {
				e.printStackTrace();
				} 
		}
		else
		{
			try {
				FileInputStream file = new FileInputStream(chemin);
				prop.loadFromXML(file);
			} 
			catch (IOException e) {e.printStackTrace();}
			
		}
		
	}

	public void maj(String[] tabReponse)
	{
		OutputStream os = null;
		String chemin = "./ihm/" + nomUtilisateur+".xml";

		prop.setProperty("Conversion Celsius/Farenheit", tabReponse[0]);
		prop.setProperty("Saisie de texte", tabReponse[1]);
		prop.setProperty("Diaporama", tabReponse[2]);
		prop.setProperty("Boutons", tabReponse[3]);
	
		
		try {
		os = new FileOutputStream(chemin);
		prop.storeToXML(os,"Préférence de l'utilisateur");
		} catch (IOException e) {e.printStackTrace(); }

	}
	
	public String getNom(){return this.nomUtilisateur;}
	public String getProperty(String clef){return this.prop.getProperty(clef);}
	public void setProperty(String clef, String message)
	{
		this.prop.setProperty(clef, message);
		OutputStream os = null;
		String chemin = "./ihm/" + nomUtilisateur+".xml";
		try {os = new FileOutputStream(chemin);	prop.storeToXML(os,"Préférence de l'utilisateur");
		} catch (IOException e) {e.printStackTrace(); }
	}

	public static Preference getPreference(){ return Preference.instance;}
}

