package edu.mermet.tp8.dialogues;


import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;

import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.BorderLayout;

import edu.mermet.tp8.preferences.Preference;
import edu.mermet.tp8.Application;


/**
 *
 * @author brunomermet
 */
public class DialogueConfigMenu extends JDialog 
{
	private JPanel panelPrincipale;
	private JPanel panelValider;

	private JRadioButton[][] tabButton;
	private ButtonGroup[] tabGroupButton;
	private JButton btnValider;
	private JButton btnAnnuler;
	private Preference preference;
	public DialogueConfigMenu(Application appli)  
	{
		super(appli,"Configuration des menus", true);
		setLayout(new BorderLayout());
		preference = Preference.getPreference();
		remplirTabButton();
		remplirButton();
		remplir();
		actualiserBoutton();		

		this.add(panelValider,"South");
		this.add(panelPrincipale,"North");
		pack();

    }

    private void remplirButton()
    {
		panelValider = new JPanel();
		btnValider = new JButton("Valider");
		btnAnnuler = new JButton("Annuler");

		btnValider.addActionListener( new ActionButton());
		btnAnnuler.addActionListener( new ActionButton());
		panelValider.add(btnValider);
		panelValider.add(btnAnnuler);
    }

    private void remplir()
    {
		String[] nomLabel  = {"Conversion Celsius/Farenheit", "Saisie de texte", "Diaporama","Boutons"};
		panelPrincipale = new JPanel();
		panelPrincipale.setLayout(new GridLayout(4,4));
		
		for (int i = 0; i < 4; i++) 
		{
			panelPrincipale.add(new JLabel(nomLabel[i]));
			for (int j = 0; j < tabButton[i].length; j++) 
				panelPrincipale.add(tabButton[i][j]);
			
		}
    }
	
	private void remplirTabButton() 
	{
		tabButton = new JRadioButton[4][3];
		String[] nomBtn = {"Auto", "Affiché", "Caché"};
		tabGroupButton = new ButtonGroup[4];

		for(int i=0; i<tabButton.length; i++)
		{
			tabGroupButton[i] = new ButtonGroup();
			for (int j = 0; j < tabButton[i].length; j++) 
			{
				tabButton[i][j] = new JRadioButton(nomBtn[j]);
				tabGroupButton[i].add(tabButton[i][j]);
			}
		}	
	}

	
	private void actualiserBoutton()
	{
		String[] nomLabel  = {"Conversion Celsius/Farenheit", "Saisie de texte", "Diaporama","Boutons"};
	
		for (int i = 0; i < tabButton.length; i++) 
		{
			for (int j = 0; j < tabButton[i].length; j++) 
			{			
				if(tabButton[i][j].getText().equals(preference.getProperty(nomLabel[i])))
				{
					tabGroupButton[i].clearSelection();
					tabButton[i][j].setSelected(true);
				}
			}
		}		
	}
	private void setVisibleFalse()
	{
		this.setVisible(false);
	}

	
	class ActionButton implements ActionListener 
	{

		@Override
		public void actionPerformed(ActionEvent e) 
		{
			if(e.getSource() == btnValider)
			{
		
				String[] tabNom = new String[5];
				String[] nomBtn = {"Auto", "Affiché", "Caché"};

				for (int i = 0; i < tabButton.length; i++)
				{
					for (int j = 0; j < tabButton[i].length; j++) 
					{
						if(tabButton[i][j].isSelected())
						tabNom[i] = nomBtn[j];
						
					}
				}
				tabNom[4] = "2";
				preference.maj(tabNom);
				setVisibleFalse();
				
			}

			if(e.getSource() == btnAnnuler)
			{
				actualiserBoutton();
			}
			
		}

	}

   
}

