package edu.mermet.tp8.dialogues;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseListener;

import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.JList;
import javax.swing.JSplitPane;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;

import edu.mermet.tp8.Application;

/**
 *
 * @author brunomermet
 */
public class DialogueCommentFaire extends JDialog {
 
    private JList choix;
    private JEditorPane editorPane;
    private ArrayList<String> aideTitre;
    private ArrayList<String> aideTextes;

    public DialogueCommentFaire(Application appli){
        super(appli,"Comment Faire", false);
        setLayout(new FlowLayout());

       ResourceBundle rbTitres = ResourceBundle.getBundle("HowTo.titres");  
       ResourceBundle rbTextes = ResourceBundle.getBundle("HowTo.textes");  

       Enumeration<String> enumTitres = rbTitres.getKeys();     
       Enumeration<String> enumTextes = rbTextes.getKeys();     
       aideTitre = new ArrayList<>();
       aideTextes = new ArrayList<>();

       while(enumTitres.hasMoreElements())
        aideTitre.add(rbTitres.getString(enumTitres.nextElement()));
            
       while(enumTextes.hasMoreElements())
        aideTextes.add(rbTextes.getString(enumTextes.nextElement()));
       

        choix= new JList(aideTitre.toArray()); 
        
        editorPane = new JEditorPane();
        editorPane.setPreferredSize(new Dimension(200,200));
        editorPane.setContentType("text/html");
        JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, choix ,editorPane  );    
        splitPane.setResizeWeight( 0.8 );
        splitPane.setResizeWeight( 0.8 );
        choix.addListSelectionListener(new ActionDialogue());

        add (splitPane);
        pack();

    }
    
    class ActionDialogue implements ListSelectionListener 
    {

        @Override
        public void valueChanged(ListSelectionEvent e)
        {
            int i = choix.getSelectedIndex();
            if(i != -1)
                editorPane.setText(aideTextes.get(i));      
        }

    }
}
