package edu.mermet.tp8;

import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;

import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;

import edu.mermet.tp8.actions.ActionAfficherBoutons;
import edu.mermet.tp8.actions.ActionAfficherConversion;
import edu.mermet.tp8.actions.ActionAfficherDiaporama;
import edu.mermet.tp8.actions.ActionAfficherTexte;
import edu.mermet.tp8.actions.ActionQuitter;
import edu.mermet.tp8.actions.ActionCommentFaire;

import edu.mermet.tp8.fenetres.AbstractFenetreInterne;
import edu.mermet.tp8.fenetres.FenetreBoutons;
import edu.mermet.tp8.fenetres.FenetreConversion;
import edu.mermet.tp8.fenetres.FenetreDiaporama;
import edu.mermet.tp8.fenetres.FenetreTexte;

import edu.mermet.tp8.dialogues.DialogueCommentFaire;

/**
 *
 * @author brunomermet
 */
public class Application extends JFrame {
	private AbstractFenetreInterne conversion;
	private AbstractFenetreInterne texte;
	private AbstractFenetreInterne diaporama;
	private AbstractFenetreInterne boutons;

	private DialogueCommentFaire commentFaire;
	private Action actionQuitter;
	private Action actionAfficherConversion;
	private Action actionAfficherTexte;
	private Action actionAfficherDiaporama;
	private Action actionAfficherBoutons;
	private Action actionCommentFaire;

	private JMenu menuFichier;
	private JMenu menuApplications;
	private JMenu menuAide;


	public Application() {
		this.setContentPane(new JDesktopPane());
		setTitle("Multi-Window");
		// ****** Barre de menu ******
		JMenuBar barre = new JMenuBar();
		// ------ menu Fichier ------
		menuFichier = new JMenu("Fichier");
		menuFichier.setMnemonic(KeyEvent.VK_F);
		actionQuitter = new ActionQuitter(this);
		JMenuItem quitter = new JMenuItem(actionQuitter);
		menuFichier.add(quitter);
		barre.add(menuFichier);
		this.setJMenuBar(barre);
		// ------ menu Applications ------
		menuApplications = new JMenu("Applications");
		menuApplications.setMnemonic(KeyEvent.VK_A);
		actionAfficherConversion = new ActionAfficherConversion(this);
		JMenuItem itemConversion = new JMenuItem(actionAfficherConversion);
		menuApplications.add(itemConversion);
		actionAfficherTexte = new ActionAfficherTexte(this);
		JMenuItem itemTexte = new JMenuItem(actionAfficherTexte);
		menuApplications.add(itemTexte);
		actionAfficherDiaporama = new ActionAfficherDiaporama(this);
		JMenuItem itemDiaporama = new JMenuItem(actionAfficherDiaporama);
		menuApplications.add(itemDiaporama);
		actionAfficherBoutons = new ActionAfficherBoutons(this);
		JMenuItem itemBoutons = new JMenuItem(actionAfficherBoutons);
		menuApplications.add(itemBoutons);
		barre.add(menuApplications);

		// ------ menu Aide ------
		menuAide = new JMenu("Aide");
		actionCommentFaire = new ActionCommentFaire(this);
		JMenuItem itemCommentFaire = new JMenuItem(actionCommentFaire);
		menuAide.add(itemCommentFaire);
		//actionitemConfig = new actionCommentFaire(this);
		JMenuItem itemConfig = new JMenuItem("Configuration des menus");
		menuAide.add(itemConfig);
		barre.add(menuAide);

		// ****** Fin barre de menu ******

		// ****** Création des fenêtres ******
		// ------ fenêtre conversion ------
		conversion = new FenetreConversion(this, actionAfficherConversion);
		this.add(conversion);
		// ------ fenêtre texte ------
		texte = new FenetreTexte(this, actionAfficherTexte);
		this.add(texte);
		// ------ fenêtre diaporama ------
		diaporama = new FenetreDiaporama(this, actionAfficherDiaporama);
		this.add(diaporama);
		// ------ fenêtre boutons ------
		boutons = new FenetreBoutons(this,actionAfficherBoutons);
		this.add(boutons);

		// ****** Fin création fenêtres ******

		// ****** Création des dialogue ******
		// ------ dialogue comment faire ------
		commentFaire = new DialogueCommentFaire(this);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setSize(600,300);
		this.setLocationRelativeTo(null);
		setVisible(true);
	}


	public void enableConversion(boolean b) {
		actionAfficherConversion.setEnabled(b);
	}

	public void enableTexte(boolean b) {
		actionAfficherTexte.setEnabled(b);
	}

	public void enableDiaporama(boolean b) {
		actionAfficherDiaporama.setEnabled(b);
	}

	public void enableBoutons(boolean b) {
		actionAfficherBoutons.setEnabled(b);
	}

	public Action getActionAfficherConversion() {
		return actionAfficherConversion;
	}

	public Action getActionAfficherTexte() {
		return actionAfficherTexte;
	}

	public Action getActionAfficherDiaporama() {
		return actionAfficherDiaporama;
	}

	public static void main(String[] args) {
		SwingUtilities.invokeLater(Application::new);
	}

	public void afficherBoutons() {
		boutons.setVisible(true);
	}
	public void afficherConversion() {
		conversion.setVisible(true);
	}
	public void afficherDiaporama() {
		diaporama.setVisible(true);
	}

	public void afficherCommentFaire()	
	{
		commentFaire.setVisible(true);

	}
	public void afficherTexte() {
		texte.setVisible(true);
	}

}
