import org.graphstream.algorithm.Dijkstra;
import org.graphstream.algorithm.generator.Generator;
import org.graphstream.algorithm.generator.RandomGenerator;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.Graphs;
import org.graphstream.graph.implementations.SingleGraph;
import org.graphstream.stream.GraphParseException;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;

public class TestDijkstra
{
    public static void main(String[] args) throws IOException, GraphParseException {

        int[] nbNode     = {10, 50, 100, 500, 1000 , 5000, 10000};
        int[] degreMoyen = {9, 30, 50};
        LinkedHashMap<Integer, Long> hmGraphStream = new LinkedHashMap<>();
        LinkedHashMap<Integer, Long> hmNaive       = new LinkedHashMap<>();

        for(Integer nombreNode: nbNode)
        {
            int degre = (nombreNode < 60 ? degreMoyen[0] : (nombreNode < 6000 ? degreMoyen[1] :degreMoyen[2]));


            //Création des graphes
            Graph g = GenererGraphe(nombreNode,degre);
            Graph g2 = Graphs.clone(g);
            Calendar c=Calendar.getInstance();
            c.setTime(new Date());

            //Dijkstra naïve
            long timeProgramme  = System.currentTimeMillis();
            //Lancement du Disjkstra naïve programmé
            MonDijkstra.Dijkstra(g);
            timeProgramme = System.currentTimeMillis() - timeProgramme;

            //GraphStream Dijkstra
            long timeStreamDijstra = System.currentTimeMillis();

            //Lancement du Disjkstra
            Dijkstra dijkstra = new Dijkstra(Dijkstra.Element.EDGE, null, "distance");
            dijkstra.init(g2);
            dijkstra.setSource(g2.getNode(0));
            dijkstra.compute();
            timeStreamDijstra = System.currentTimeMillis() - timeStreamDijstra;

            // Créer un fichier contenant le plus court chemin pour chaque noeud
            CreationFichier.creerFichierParcours(nombreNode+"" , g);
            hmGraphStream.put(nombreNode, timeStreamDijstra);
            hmNaive.put(nombreNode, timeProgramme);
        }
        CreationFichier.creerFichier("TempsExecNaive" , hmNaive);
        CreationFichier.creerFichier("TempsExecGS" , hmGraphStream);
        CreationFichier.creerGraphe("TempsExecNaive", "TempsExecGS");
        System.out.println("Vous trouverez le graphe comparant les temps d'exécution des deux algorithme de Dijkstra");

    }

    public static Graph GenererGraphe(int nbSommet, double degreMoyen)
    {
        Graph g = new SingleGraph("Graphe aléatoire");
        g.setAttribute("ui.quality");
        g.setAttribute("ui.antialias");

        Generator gen = new RandomGenerator(degreMoyen,false, true);
        gen.addSink(g);
        gen.begin();
        while (g.getNodeCount() < nbSommet && gen.nextEvents());

        gen.end();
        g.getNode(0).setAttribute("poids",0);

        for (int i = 1; i < g.getNodeCount(); i++)
            g.getNode(i).setAttribute("poids",Integer.MAX_VALUE);

        for (int i = 0; i < g.getEdgeCount(); i++)
            g.getEdge(i).setAttribute("distance",(int)(Math.random()*99)+1);
        return g;
    }

    public static Graph GenererGraphe(String nomFichier) throws IOException, GraphParseException {
        Graph g = new SingleGraph("grapheAvecFichier");
        g.read("data/"+nomFichier+".dgs");
        System.setProperty("org.graphstream.ui", "swing");

        g.setAttribute("ui.quality");
        g.setAttribute(("ui.antialias"));

        g.getNode(0).setAttribute("poids",0);

        for (int i = 1; i < g.getNodeCount(); i++)
            g.getNode(i).setAttribute("poids",Integer.MAX_VALUE);

        System.setProperty("org.graphstream.ui", "swing");
        return g;
    }


}
