import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;

import java.util.ArrayList;

public class MonDijkstra
{
	public static void Dijkstra(Graph g)
	{
		ArrayList<Node> sommets = getNodes(g);
		Node u = sommetMin(sommets);
		while (u != null)
		{
			sommets.remove(u);
			u.setAttribute("marque", true);
			ArrayList<Node> voisins = new ArrayList<>();
			u.leavingEdges().forEach(edge -> voisins.add(edge.getNode1()));

			for (Node n : voisins)
			{
				Edge e = u.getEdgeBetween(n);
				Node voisin = n;

				int poidsU = (int) u.getAttribute("poids");
				int poidVoisin = (int) voisin.getAttribute("poids");
				int distUV = (int) e.getAttribute("distance");

				if (poidVoisin > (poidsU + distUV) && !(voisin.hasAttribute("marque")))
				{
					voisin.setAttribute("poids", poidsU + distUV);
					voisin.setAttribute("pere", u.getId());
				}

			}
			u = sommetMin(sommets);
		}
	}

	private static ArrayList getNodes(Graph g)
	{
		ArrayList<Node> alNode= new ArrayList<>();
		for (int i = 0; i < g.getNodeCount(); i++) {
			alNode.add(g.getNode(i));

		}
		return alNode;
	}

	private static Node sommetMin (ArrayList<Node> sommets)
	{
		Node minSommet = null;
		int minval = Integer.MAX_VALUE;

		for (Node n : sommets)
		{

			if(((int)(n.getAttribute("poids")) < minval))
			{
				minval = (int) n.getAttribute("poids");
				minSommet = n;
			}

		}
		return minSommet;
	}
}
