import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;

public class CreationFichier
{
	public static void creerFichierParcours(String nomFichier, Graph g)
	{
		try {
			File f = new File("./data/ResultatParcours/" + nomFichier + ".dat");
			FileWriter writer = new FileWriter(f);
			writer.write( String.format("%-6s %5s %5s\n", "Noeud", "Poids", "Pere"));

			for (int i = 0; i < g.getNodeCount(); i++){
				Node n = g.getNode(i);
				writer.write(String.format("%-6s %5s %5s\n",n.getId(), ((int)n.getAttribute("poids") != Integer.MAX_VALUE ? n.getAttribute("poids"):"") ,
						(n.getAttribute("pere") != null ? n.getAttribute("pere"):"")));

			}

			writer.close();

		} catch (Exception e) {System.out.println(e);}
	}

	public static void creerGraphe(String nomFichier1, String nomFichier2)
	{
		try {

			File f = new File("./gnuplot/Dijkstra.gnuplot");
			FileWriter writer = new FileWriter(f);
			writer.write(
					"set terminal  png \n" +
							"set encoding utf8 \n" +
							"set output \"./graphe/Graphe.png\n" +
							"set xlabel  'Nombre de noeuds' \n" +
							"set ylabel  'Temps (ms)' \n" +
							"plot   \"./data/"+nomFichier1+".dat\"  title 'Dijkstra GraphStream' with linesp lt 1 pt 1 lc 1,"+
							"\"./data/"+nomFichier2+".dat\" title' Dijkstra Naive' with linesp lt 2 pt 1 lc 2"
			);
			writer.close();

		} catch (IOException e) {e.printStackTrace();}

		try {
			Runtime commandPrompt = Runtime.getRuntime();
			commandPrompt.exec("gnuplot ./gnuplot/Dijkstra.gnuplot");
		} catch (IOException e) {System.out.println(e);}
	}

	public static void creerFichier(String nomFichier, LinkedHashMap<Integer, Long> resultat)
	{
		try {
			File f = new File("./data/" + nomFichier + ".dat");
			FileWriter writer = new FileWriter(f);

			for (Integer key : resultat.keySet())
				writer.write(key + " " + resultat.get(key) + "\n");
			writer.close();

		} catch (Exception e) {System.out.println(e);}
	}
}
