import org.graphstream.algorithm.generator.BarabasiAlbertGenerator;
import org.graphstream.algorithm.generator.Generator;
import org.graphstream.algorithm.generator.RandomGenerator;
import org.graphstream.graph.Graph;
import org.graphstream.graph.implementations.SingleGraph;
import org.graphstream.stream.file.FileSourceEdge;

import java.io.IOException;

public class GenererGraphe
{

	public static Graph genererGrapheFichier(String nomFichier)
	{
		Graph graphe = new SingleGraph("Graphe");

		FileSourceEdge fs = new FileSourceEdge();

		fs.addSink(graphe);

		try {
			fs.readAll("data/com-dblp.ungraph.txt");
		} catch (IOException e) {
			System.out.println("Fichier non trouvé");
		} finally {
			fs.removeSink(graphe);
		}
		return graphe;
	}
	public static Graph genererGrapheBarabasiAlbert(int maxLinksPerStep, int nbNoeud)
	{
		Graph grapheAlbert = new SingleGraph("Barabàsi-Albert");
		Generator gen = new BarabasiAlbertGenerator(maxLinksPerStep);
		gen.addSink(grapheAlbert);
		gen.begin();

		for(int i=0; i<nbNoeud; i++) {
			gen.nextEvents();
		}

		gen.end();
		return  grapheAlbert;
	}
	public static Graph genererAleatoire(double averageDegree, int nbNoeud)
	{
		Graph grapheAleatoire = new SingleGraph("Graphe Aléatoire");
		Generator gen = new RandomGenerator(averageDegree);
		gen.addSink(grapheAleatoire);
		gen.begin();
		for(int i=0; i<nbNoeud; i++)
			gen.nextEvents();
		gen.end();
		return grapheAleatoire;
	}



}
