import java.io.File;
import java.io.FileWriter;

public class CreationFichier
{
	public static void creerFichier(double[] tabResultat, String nomFichier)
	{
		try {
			File f = new File("./data/" + nomFichier + ".dat");
			FileWriter writer = new FileWriter(f);
			for (int i = 1; i < tabResultat.length; i++)
				writer.write(i + " " + tabResultat[i] + "\n");

			writer.close();

		} catch (Exception e) {
			System.out.println(e);
		}
	}

	public static void creerFichier(int[] tabResultat)
	{
		try {
			File f = new File("./data/ResultatDistance.dat");
			FileWriter writer = new FileWriter(f);
			for (int i = 1; i < tabResultat.length; i++)
				writer.write(i + " " + tabResultat[i] + "\n");

			writer.close();

		} catch (Exception e) {
			System.out.println(e);
		}
	}

	public static void creerGrapheLineaire(String nomFichier, String fichierResultat)
	{
		File dossier = new File("./gnuplot");
		if(!dossier.exists())
			dossier.mkdir();
		dossier = new File("./graphes");
		if(!dossier.exists())
			dossier.mkdir();

		try {
			File f = new File("./gnuplot/" + nomFichier+ ".gnuplot");
			FileWriter writer = new FileWriter(f);
			writer.write(
					"set terminal png\n" +
							"set title \"Distribution des degrés\"\n" +
							"set xlabel 'k'\n" +
							"set ylabel 'p(k)'\n" +
							"set output './graphes/"+nomFichier+".png'\n" +
							"plot './data/"+ fichierResultat+".dat' title 'Distribution des degrés' with linesp lt 2 pt 2 lc 2"
			);
			writer.close();
		} catch (Exception e) {
			System.out.println(e);
		}

		try {
			Runtime commandPrompt = Runtime.getRuntime();
			commandPrompt.exec("gnuplot ./gnuplot/"+nomFichier+".gnuplot");
		} catch (Exception e) {
			System.out.println(e);
		}
	}

	public static void creerGrapheLogLog(String nomFichier, String fichierResultat)
	{
		File dossier = new File("./gnuplot");
		if(!dossier.exists())
			dossier.mkdir();
		dossier = new File("./graphes");
		if(!dossier.exists())
			dossier.mkdir();
		try {
			File f = new File("./gnuplot/"+nomFichier+".gnuplot");
			FileWriter writer = new FileWriter(f);
			writer.write(
					"set terminal png\n" +
							"set title \"Distribution des degrés\"\n" +
							"set xlabel 'k'\n" +
							"set ylabel 'p(k)'\n" +
							"set output './graphes/"+nomFichier+".png'\n" +
							"set logscale xy\n" +
							"set yrange [1e-6:1]\n" +
							"plot './data/"+fichierResultat+".dat' title 'Distribution des degrés' with linesp lt 2 pt 2 lc 2"
			);
			writer.close();
		} catch (Exception e) {
			System.out.println(e);
		}

		try {
			Runtime commandPrompt = Runtime.getRuntime();
			commandPrompt.exec("gnuplot ./gnuplot/"+nomFichier+".gnuplot");
		} catch (Exception e) {
			System.out.println(e);
		}
	}

	public static void creerGraphePoisson(String nomFichier, String fichierResultat)
	{
		File dossier = new File("./gnuplot");
		if(!dossier.exists())
			dossier.mkdir();

		dossier = new File("./graphes");
		if(!dossier.exists())
			dossier.mkdir();

		dossier = new File("./gnuplot/poisson");
		if(!dossier.exists())
			dossier.mkdir();

		dossier = new File("./graphes/poisson");
		if(!dossier.exists())
			dossier.mkdir();

		try {
			File f = new File("./gnuplot/poisson/"+nomFichier+".gnuplot");
			FileWriter writer = new FileWriter(f);
			writer.write(
					"set terminal png\n" +
							"set title \"Distribution des degrés\"\n" +
							"set xlabel 'k'\n" +
							"set ylabel 'p(k)'\n" +
							"set output './graphes/poisson/"+nomFichier+".png'\n" +
							"set logscale xy\n" +
							"set yrange [1e-6:1]\n" +
							"# Poisson\n" +
							"lambda = 6.62208890914917\n" +
							"poisson(k) = lambda ** k * exp(-lambda) / gamma(k + 1)\n" +
							"\n" +
							"# on va fitter une fonction linéaire en log-log\n" +
							"\n" +
							"f(x) = lc - gamma * x\n" +
							"fit f(x) './data/"+fichierResultat+".dat' using (log($1)):(log($2)) via lc, gamma\n" +
							"c = exp(lc)\n" +
							"power(k) = c * k ** (-gamma)\n" +
							"plot './data/"+fichierResultat+".dat' title 'DBLP', \\\n" +
							"poisson(x) title 'Loi de poisson', \\\n" +
							"power(x) title 'Loi de puissance'\n"
			);
			writer.close();
		} catch (Exception e) {
			System.out.println(e);
		}

		try {
			Runtime commandPrompt = Runtime.getRuntime();
			commandPrompt.exec("gnuplot ./gnuplot/poisson/"+nomFichier+".gnuplot");
		} catch (Exception e) {
			System.out.println(e);
		}
	}

	public static void creerGrapheDistance(int[] tabResultat, String  nomFichier)
	{
		File dossier = new File("./gnuplot");
		if(!dossier.exists())
			dossier.mkdir();

		dossier = new File("./graphes");
		if(!dossier.exists())
			dossier.mkdir();

		dossier = new File("./gnuplot/distance");
		if(!dossier.exists())
			dossier.mkdir();

		dossier = new File("./graphes/distance");
		if(!dossier.exists())
			dossier.mkdir();
		dossier = new File("./data/distance");
		if(!dossier.exists())
			dossier.mkdir();

		try {
			File f = new File("./data/distance/Resultat"+nomFichier+".dat");
			FileWriter writer = new FileWriter(f);
			for (int i = 1; i < tabResultat.length; i++)
				writer.write(i + " " + tabResultat[i] + "\n");

			writer.close();

		} catch (Exception e) {
			System.out.println(e);
		}


		try {
			File f = new File("./gnuplot/distance/"+nomFichier+".gnuplot");
			FileWriter writer = new FileWriter(f);
			writer.write(
					"set terminal png\n" +
							"set title \"Distribution des distances\"\n" +
							"set xlabel 'nombre de noeud'\n" +
							"set ylabel 'nombre Distances'\n" +
							"set output './graphes/distance/"+nomFichier+".png'\n" +
							"plot './data/distance/Resultat"+nomFichier+".dat' title 'Distribution des distances' with linesp lt 2 pt 2 lc 2"
			);
			writer.close();
		} catch (Exception e) {
			System.out.println(e);
		}

		try {
			Runtime commandPrompt = Runtime.getRuntime();
			commandPrompt.exec("gnuplot ./gnuplot/distance/"+nomFichier+".gnuplot");
		} catch (Exception e) {
			System.out.println(e);
		}
	}
}
