export const version = () => "1.0.0";


export class Sensor {
    constructor(id, name, data) {
        this._id = id;
        this._name = name;
        this._data = data;
    }
    get name() {
        return this._name;
    }
    set name(val) {
        if(typeof val === 'string' || typeof val === 'undefined') {
            this._name = val;
        }
    }
    set id(val) {
        if(typeof val === 'number' || typeof val === 'undefined'){
            this._id = val;
        }
    }
    get id() {
        return this._id;
    }
    set data(val) {
        this._data = val;
    }
    get data() {
        return this._data;
    }
}

export class Positive_number extends Sensor{

}

export class Percent extends Sensor{

}

export class temperature extends Sensor{

}

export class on_off extends Sensor{

}

export class open_close extends Sensor{

}


export class Data {

    get tab() {
        return this._tab;
    }
    set tab(val) {
        this._tab.push(val);
    }
}

export class Datum extends Data {
    constructor(value) {
        super();
        this._value = value;
    }
    get value() {
        return this._value;
    }
    set value(val) {
            this._value = val;
    }


}

/*---------------------------------------------------------*/

export function fData (array) {
    return new Datum(array.value);
}

export function fSensorType(data, type) {
    if(type === "POSITIVE_NUMBER"){
        return new Positive_number(data.id, data.name, data.data);
    }
    else if(type === "PERCENT"){
        return new Percent(data.id, data.name, data.data);
    }
    else if(type === "TEMPERATURE"){
        return new temperature(data.id, data.name, data.data);
    }
    else if(type === "ON_OFF"){
        return new on_off(data.id, data.name, data.data);
    }
    else if(type === "OPEN_CLOSE"){
        return new open_close(data.id, data.name, data.data);
    }
}
