import React, { Component } from 'react';
import logo from './logo.svg';
import mqtt from 'mqtt'
import Capteur from './Capteur'

import './App.css';
import {
    Link
} from 'react-router-dom'

import {
    Sensor,
    Datum,
    fSensorType
} from './class';


//tableau intermédiaire contenant mes capteurs groupé par type de capteur
var capteurs = [];


class App extends Component {


    /*
    value : url de connexion
    capts : tableau des capteurs groupé par type de capteur
    i : incrementation de l'id des capteurs
     */
    constructor(props) {
        super(props);
        this.state = {value: '', capts: [], i:0};

        this.handleChange = this.handleChange.bind(this);
        this.handleSubmit = this.handleSubmit.bind(this);
        this.getCurrentCapteur = this.getCurrentCapteur.bind(this);

        this.setState({
            capts: capteurs
        });

    }

    handleChange(event) {
        this.setState({value: event.target.value});
    }

    handleSubmit(event) {
         this.connexion(this.state.value);
        event.preventDefault();
    }

    //sur clic sur le bouton de connection
    connexion(url) {
        const ws = new WebSocket("ws://" + url);
        ws.onopen = (event) => {
            console.log("We are connected.");
        };

        ws.onclose = function (event) {
            console.log("Fin de communication");
        }

        //MQTT
        var client = mqtt.connect("mqtt://" + url)
        client.subscribe("#");


        const that = this;


        client.on('message', function (topic, message) {
            //permet de récupérer tous les capteurs et de les mettre dans le tableau capts
            //créer l'historique (capts.tab)
            //-------------------------------------------------
            var objet = JSON.parse(message);
            var name = topic.split("/");
            var datum = new Datum(objet.value);
            var data = new Sensor(this.i, name[1], datum.value);
            var objetfinal = fSensorType(data, objet.type);


            if (capteurs.length === 0) {
                objetfinal.tab = [];
                objetfinal.id = this.i;
                capteurs.push(objetfinal);
            } else {
                var j = that.existeElement(objetfinal, capteurs);
                if (j !== -1) {
                    capteurs[j].data = data;
                    if(capteurs[j].tab.length < 10){
                        capteurs[j].tab.push(datum.value);
                    }else{
                        capteurs[j].tab.shift();
                        capteurs[j].tab.push(datum.value);
                    }
                }
                else {
                    objetfinal.tab = [];
                    objetfinal.tab.push(datum.value);
                    objetfinal.id = this.i;
                    capteurs.push(objetfinal);
                }
            }

            that.setState({
                capts: capteurs,
                i: this.i + 1
            });
        })
        //---------------------------------------------------------

    }

    //permet de savoir si le capteur a déjà été rentré dans le tableau ou non
    existeElement(sensor, capteurs){
        var j;
        for( j=0; j<capteurs.length; j++){
            if(capteurs[j].name === sensor.name){
                return j;
            }
        }
        return -1;
    }


    //permet de récupérer le capteur sur lequel on clique dans la navigation
    getCurrentCapteur(){
        const chemin = this.props.location.pathname.substr(1,this.props.location.pathname.length);

        if(this.state.capts[this.state.capts.length-1] !== undefined){
            for(let j=0;j<this.state.capts.length;j++){
                if(this.state.capts[j].name === chemin){
                    return this.state.capts[j];
                }
            }
        }
    }

    render() {
        //on affiche la liste des capteurs
        const naviguation = this.state.capts.map((s) =>

            <li><Link to={s.name}>
                { s.name}
            </Link></li>
        );

        return (
            <div className="App">
                <header className="App-header">
                    <img src={logo} className="App-logo" alt="logo" />
                    <h1 className="App-title">Welcome to My Sensor</h1>
                </header>

                <form onSubmit={this.handleSubmit}>
                    <label>
                        URL du Brocker : <input type="text" placeholder="127.0.0.1:1234" value={this.state.value} onChange={this.handleChange} />
                    </label>
                    <input type="submit" value="Submit" />
                </form>

                <div class="wrapper">
                    <article>
                        <div id="route">
                           <Capteur value={this.getCurrentCapteur()}/>
                        </div>
                    </article>

                    <nav>
                        <div class="navigation">
                            <ul>
                                {naviguation}
                            </ul>
                        </div>
                    </nav>
                </div>
            </div>
        );
    }
}

export default App;



