import React from "react";
import "./ScatterPlot.css";

const mockData = [
  { commune: "Paris", taux: 1.2, volume: 1200000 },
  { commune: "Marseille", taux: 1.1, volume: 800000 },
  { commune: "Lyon", taux: 1.0, volume: 950000 },
];

const ScatterPlot: React.FC = () => {
  return (
    <div className="scatter-plot-container">
      <div className="scatter-plot-placeholder">
        <div className="loading-animation">
          <div className="dot"></div>
          <div className="dot"></div>
          <div className="dot"></div>
        </div>
        <p className="placeholder-text">ScatterPlot Canvas/WebGL</p>
        <div className="mock-data-preview">
          {mockData.map((item, index) => (
            <div key={index} className="data-point">
              <span className="point-marker" style={{ animationDelay: `${index * 0.2}s` }}>
                •
              </span>
              <span>{item.commune}</span>
            </div>
          ))}
        </div>
      </div>
    </div>
  );
};

export default ScatterPlot;
