<?php

namespace App\ApiResource;

use ApiPlatform\Metadata\ApiProperty;
use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\GetCollection;
use App\State\RegionalDistributionProvider;

#[ApiResource(
    operations: [
        new GetCollection(
            uriTemplate: '/stats/regional-distribution',
            provider: RegionalDistributionProvider::class,
            paginationEnabled: false
        ),
    ]
)]
final class RegionalDistribution
{
    #[ApiProperty(identifier: true)]
    public string $regionCode;

    public string $regionName;

    public float $collectedVolume;
}
