<?php

namespace App\ApiResource;

use ApiPlatform\Metadata\ApiProperty;
use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\GetCollection;
use App\State\RegionEvolutionProvider;

#[ApiResource(
    operations: [
        new GetCollection(
            uriTemplate: '/stats/region-evolution',
            provider: RegionEvolutionProvider::class,
            paginationEnabled: false
        ),
    ]
)]
final class RegionEvolutionPoint
{
    #[ApiProperty(identifier: true)]
    public string $id;

    public int $year;

    public string $regionCode;

    public string $regionName;

    public float $rate;
}
