<?php

namespace App\ApiResource;

use ApiPlatform\Metadata\ApiProperty;
use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\GetCollection;
use App\State\DepartmentCorrelationProvider;

#[ApiResource(
    operations: [
        new GetCollection(
            uriTemplate: '/stats/department-correlation',
            provider: DepartmentCorrelationProvider::class,
            paginationEnabled: false
        ),
    ]
)]
final class DepartmentCorrelationPoint
{
    #[ApiProperty(identifier: true)]
    public string $communeCode;

    public float $rate;

    public float $collectedVolume;
}
