import React from "react";
import { TaxType } from "../../../api/stats";
import { AVAILABLE_YEARS } from "./circulardiagram.utils";

const TAX_LABELS: Record<TaxType, string> = {
  tfpnb: "tfpnb",
  tfpb: "tfpb",
  th: "th",
  cfe: "cfe",
};

type Props = {
  selectedTax: TaxType;
  year: number;
  onTaxChange: (t: TaxType) => void;
  onYearChange: (y: number) => void;
};

export const CircularDiagramControls: React.FC<Props> = ({
    selectedTax,
    year,
    onTaxChange,
    onYearChange,
}) => {
    return (
      <div className="controls-panel">
        <div className="control-group">
          <label className="control-label">Type de taxe</label>
          <div className="button-group">
            {(Object.keys(TAX_LABELS) as TaxType[]).map((tax) => (
              <button
                key={tax}
                className={`filter-button ${selectedTax === tax ? "active" : ""}`}
                onClick={() => onTaxChange(tax)}
                type="button"
              >
                {TAX_LABELS[tax]}
              </button>
            ))}
          </div>
        </div>

        <div className="control-group">
          <label className="control-label">Année</label>
  
          <div className="controls">
            <div className="selector">
              <span className="label">En</span>
              <select
                className="select"
                value={year}
                onChange={(e) => onYearChange(Number(e.target.value))}
              >
                {AVAILABLE_YEARS.map((year) => (
                  <option key={year} value={year}>
                    {year}
                  </option>
                ))}
              </select>
            </div>
          </div>
        </div>
      </div>
    );
};