import React from "react";
import GlassCard from "../components/layout/GlassCard";
import "./Dashboard.css";
import TimeSeriesSVG from "../components/charts/TimeSeries/TimeSeries";

const Dashboard: React.FC = () => {
  return (
    <div className="dashboard">
      <div className="dashboard-container">
        {/* Header */}
        <header className="dashboard-header">
          <GlassCard>
            <h1 className="dashboard-title">
              <span className="title-gradient">Tableau de Bord</span>
            </h1>
            <p className="dashboard-subtitle">
              Analyse des données immobilières en temps réel
            </p>
          </GlassCard>
        </header>

        {/* Stats Cards */}
        <div className="stats-grid">
          <GlassCard hover>
            <div className="stat-card">
              <div className="stat-icon">📊</div>
              <div className="stat-content">
                <h3 className="stat-value">1,234</h3>
                <p className="stat-label">Transactions</p>
              </div>
            </div>
          </GlassCard>

          <GlassCard hover>
            <div className="stat-card">
              <div className="stat-icon">🏘️</div>
              <div className="stat-content">
                <h3 className="stat-value">42</h3>
                <p className="stat-label">Communes</p>
              </div>
            </div>
          </GlassCard>

          <GlassCard hover>
            <div className="stat-card">
              <div className="stat-icon">💰</div>
              <div className="stat-content">
                <h3 className="stat-value">€2.4M</h3>
                <p className="stat-label">Volume Total</p>
              </div>
            </div>
          </GlassCard>

          <GlassCard hover>
            <div className="stat-card">
              <div className="stat-icon">📈</div>
              <div className="stat-content">
                <h3 className="stat-value">+12%</h3>
                <p className="stat-label">Croissance</p>
              </div>
            </div>
          </GlassCard>
        </div>

        {/* Main Chart */}
        <div className="chart-section">
          <GlassCard>
            <div className="chart-header">
              <h2 className="chart-title">Analyse par Commune</h2>
              {/* <div className="chart-controls">
                <button className="btn-glass">Jour</button>
                <button className="btn-glass active">Semaine</button>
                <button className="btn-glass">Mois</button>
              </div> */}
            </div>
            <TimeSeriesSVG />
          </GlassCard>
        </div>

        {/* Additional Info */}
        <div className="info-grid">
          <GlassCard hover>
            <h3 className="info-title">🎯 Top Communes</h3>
            <ul className="info-list">
              <li>Paris - €1.2M</li>
              <li>Lyon - €950K</li>
              <li>Marseille - €800K</li>
            </ul>
          </GlassCard>

          <GlassCard hover>
            <h3 className="info-title">📅 Dernière mise à jour</h3>
            <p className="info-text">
              Données actualisées il y a 5 minutes
            </p>
            <div className="pulse-indicator">
              <span className="pulse-dot"></span>
              <span>Actif</span>
            </div>
          </GlassCard>
        </div>
      </div>
    </div>
  );
};

export default Dashboard;
