import { apiGet } from "./http";
import { HydraCollection } from "../models/hydra";
import { RegionEvolutionPoint } from "../models/RegionEvolution";

export type TaxType = "tfpnb" | "tfpb" | "th" | "cfe";

export interface RegionEvolutionParams {
  tax?: TaxType;
  startYear?: number;
  endYear?: number;
}

export function getRegionEvolution(params?: RegionEvolutionParams) {
  const queryParams = new URLSearchParams();

  if (params?.tax) {
    queryParams.append("tax", params.tax);
  }
  if (params?.startYear) {
    queryParams.append("startYear", params.startYear.toString());
  }
  if (params?.endYear) {
    queryParams.append("endYear", params.endYear.toString());
  }

  const queryString = queryParams.toString();
  const url = `/stats/region-evolution${queryString ? `?${queryString}` : ""}`;

  return apiGet<HydraCollection<RegionEvolutionPoint>>(url);
}
