import React from "react";
import { TaxType } from "../../../api/stats";
import { AVAILABLE_YEARS } from "./timeseries.utils";
import "./TimeSeries.css";

const TAX_LABELS: Record<TaxType, string> = {
  tfpnb: "tfpnb",
  tfpb: "tfpb",
  th: "th",
  cfe: "cfe",
};

type Props = {
  selectedTax: TaxType;
  startYear: number;
  endYear: number;
  onTaxChange: (t: TaxType) => void;
  onStartYearChange: (y: number) => void;
  onEndYearChange: (y: number) => void;
};

export const TimeSeriesControls: React.FC<Props> = ({
  selectedTax,
  startYear,
  endYear,
  onTaxChange,
  onStartYearChange,
  onEndYearChange,
}) => {
  return (
    <div className="controls-panel">
      <div className="control-group">
        <label className="control-label">Type de taxe</label>
        <div className="button-group">
          {(Object.keys(TAX_LABELS) as TaxType[]).map((tax) => (
            <button
              key={tax}
              className={`filter-button ${selectedTax === tax ? "active" : ""}`}
              onClick={() => onTaxChange(tax)}
              type="button"
            >
              {TAX_LABELS[tax]}
            </button>
          ))}
        </div>
      </div>

      <div className="control-group">
        <label className="control-label">Période</label>

        <div className="year-controls">
          <div className="year-selector">
            <span className="year-label">De</span>
            <select
              className="year-select"
              value={startYear}
              onChange={(e) => onStartYearChange(Number(e.target.value))}
            >
              {AVAILABLE_YEARS.map((year) => (
                <option key={year} value={year}>
                  {year}
                </option>
              ))}
            </select>
          </div>

          <div className="year-selector">
            <span className="year-label">À</span>
            <select
              className="year-select"
              value={endYear}
              onChange={(e) => onEndYearChange(Number(e.target.value))}
            >
              {AVAILABLE_YEARS.map((year) => (
                <option key={year} value={year}>
                  {year}
                </option>
              ))}
            </select>
          </div>
        </div>
      </div>
    </div>
  );
};
