import React from "react";
import { TaxType } from "../../../api/stats";
import { AVAILABLE_YEARS, DEPARTEMENTS } from "./scatterplot.utils";
import "./ScatterPlot.css";

const TAX_LABELS: Record<TaxType, string> = {
  tfpnb: "tfpnb",
  tfpb: "tfpb",
  th: "th",
  cfe: "cfe",
};

type Props = {
  selectedTax: TaxType;
  year: number;
  department: string;
  onTaxChange: (t: TaxType) => void;
  onYearChange: (y: number) => void;
  onDepartmentChange: (y: string) => void;
};

export const ScatterPlotControls: React.FC<Props> = ({
    selectedTax,
    year,
    department,
    onTaxChange,
    onYearChange,
    onDepartmentChange,
}) => {
    return (
      <div className="controls-panel">
        <div className="control-group">
          <label className="control-label">Type de taxe</label>
          <div className="button-group">
            {(Object.keys(TAX_LABELS) as TaxType[]).map((tax) => (
              <button
                key={tax}
                className={`filter-button ${selectedTax === tax ? "active" : ""}`}
                onClick={() => onTaxChange(tax)}
                type="button"
              >
                {TAX_LABELS[tax]}
              </button>
            ))}
          </div>
        </div>

        <div className="control-group">
          <label className="control-label">Année</label>
  
          <div className="controls">
            <div className="selector">
              <span className="label">En</span>
              <select
                className="select"
                value={year}
                onChange={(e) => onYearChange(Number(e.target.value))}
              >
                {AVAILABLE_YEARS.map((year) => (
                  <option key={year} value={year}>
                    {year}
                  </option>
                ))}
              </select>
            </div>
          </div>
        </div>

        <div className="control-group">
          <label className="control-label">Département</label>
  
          <div className="controls">
            <div className="selector">
              <span className="label">De</span>
              <select
                className="select"
                value={department}
                onChange={(e) => onDepartmentChange(String(e.target.value))}
              >
                  {Object.entries(DEPARTEMENTS).map(([department, nom]) => (
                    <option key={department} value={department}>
                      {nom}
                    </option>
                  ))}
              </select>
            </div>
          </div>
        </div>
      </div>
    );
};